% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/containerResizer.R
\name{sizeableCard}
\alias{sizeableCard}
\title{Resizable container content holder}
\usage{
sizeableCard(..., bg.color = NULL, border.color = NULL)
}
\arguments{
\item{...}{content of container}

\item{bg.color}{content background color e.g red, black or #333333}

\item{border.color}{border color of container e.g. red or #f5f5f5}
}
\value{
Container with a resizing toolbar feature on the right
}
\description{
Highly customizable and resizable  container content holder
}
\section{Examples for r2resize}{

More examples and demo pages are located at this link -
\url{https://rpkg.net/package/r2resize}.
}

\examples{
#simple sizeable card attribute
r2resize::sizeableCard(
  "sample rpkg.net text"
)


#specify the background color for the card
r2resize::sizeableCard(
  "sample r2resume text",
  bg.color = "lightgray"
)


#specify the border color additionally
r2resize::sizeableCard(
  "sample r2resume text",
  bg.color = "lightgray",
  border.color="black"
)

}
