/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ConstantFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.DerivedOutputField;
import org.jpmml.converter.DiscreteLabel;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.Label;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.ModelEncoder;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.converter.transformations.ExpTransformation;
import org.jpmml.rexp.ModelConverter;
import org.jpmml.rexp.RClosure;
import org.jpmml.rexp.RDoubleVector;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RFunctionCall;
import org.jpmml.rexp.RGenericVector;
import org.jpmml.rexp.RNumberVector;
import org.jpmml.rexp.RPair;
import org.jpmml.rexp.RString;
import org.jpmml.rexp.RStringVector;
import org.jpmml.rexp.RVector;

public class MaxLikConverter
extends ModelConverter<RGenericVector> {
    private RFunctionCall settings = null;
    private Map<String, RExp> variables = null;
    private Map<?, RFunctionCall> utilityFunctions = null;
    private RFunctionCall nlNests = null;
    private Map<?, RFunctionCall> nlStructures = null;
    private Map<?, Number> lambdas = null;
    private Map<?, ?> nlTree = null;
    private Map<?, Feature> availabilityFeatures = null;
    private Map<?, Feature> utilityFunctionFeatures = null;
    private Map<?, Feature> expUtilityFunctionFeatures = null;
    private static final String TYPE_MNL = "MNL";
    private static final String TYPE_NL = "NL";
    private static final int SIGN_MINUS = -1;
    private static final int SIGN_PLUS = 1;

    public MaxLikConverter(RGenericVector maxLik) {
        super(maxLik);
    }

    @Override
    public void encodeSchema(final RExpEncoder encoder) {
        this.parseApolloProbabilities();
        RGenericVector maxLik = (RGenericVector)this.getObject();
        RDoubleVector estimate = maxLik.getDoubleElement("estimate");
        RStringVector modelTypeList = maxLik.getStringElement("modelTypeList");
        RStringVector estimateNames = estimate.names();
        LinkedHashMap<String, Double> estimates = new LinkedHashMap<String, Double>();
        for (int i = 0; i < estimate.size(); ++i) {
            estimates.put(estimateNames.getDequotedValue(i), estimate.getValue(i));
        }
        String modelType = modelTypeList.getValue(0);
        RFunctionCall settings = this.settings;
        if (settings == null) {
            throw new IllegalArgumentException("Invalid 'apollo_probabilities' element. Missing model settings (variable '" + modelType.toLowerCase() + "_settings')");
        }
        Map<String, RExp> settingsMap = MaxLikConverter.parseList(settings, value -> value);
        RFunctionCall alternatives = (RFunctionCall)settingsMap.get("alternatives");
        RFunctionCall availabilities = (RFunctionCall)settingsMap.get("avail");
        RString choiceVar = (RString)settingsMap.get("choiceVar");
        List choices = MaxLikConverter.parseVector(alternatives).entrySet().stream().sorted((left, right) -> ((Comparable)left.getValue()).compareTo((Comparable)right.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
        Map<String, RExp> variables = this.variables;
        Map<?, RFunctionCall> utilityFunctions = this.utilityFunctions;
        if (utilityFunctions.isEmpty()) {
            throw new IllegalArgumentException("Invalid 'apollo_probabilities' element. Missing utility function set (variable 'V')");
        }
        if (!new LinkedHashSet(choices).equals(utilityFunctions.keySet())) {
            throw new IllegalArgumentException("Invalid 'apollo_probabilities' element. Invalid utility function set");
        }
        DataField choiceField = encoder.createDataField(choiceVar.getValue(), OpType.CATEGORICAL, TypeUtil.getDataType(choices, (DataType)DataType.STRING), choices);
        encoder.setLabel(choiceField);
        Map<String, Feature> availabilityFeatures = null;
        if (availabilities != null) {
            Function<RExp, Feature> function = new Function<RExp, Feature>(){

                @Override
                public Feature apply(RExp rexp) {
                    if (rexp instanceof RString) {
                        RString string = (RString)rexp;
                        DataField availabilityField = encoder.createDataField(string.getValue(), OpType.CONTINUOUS, DataType.INTEGER, Arrays.asList(0, 1));
                        encoder.addDecorator((Field)availabilityField, (Decorator)new MissingValueDecorator(MissingValueTreatmentMethod.AS_VALUE, (Object)1));
                        return new ContinuousFeature((PMMLEncoder)encoder, (Field)availabilityField);
                    }
                    throw new IllegalArgumentException();
                }
            };
            availabilityFeatures = MaxLikConverter.parseList(availabilities, function);
        }
        LinkedHashMap utilityFunctionFeatures = new LinkedHashMap();
        LinkedHashMap expUtilityFunctionFeatures = new LinkedHashMap();
        for (Object choice : choices) {
            RFunctionCall functionCall = utilityFunctions.get(choice);
            RegressionModel model = this.encodeUtilityFunction(choice, functionCall, variables, estimates, encoder);
            encoder.addTransformer((Model)model);
            Output output = model.getOutput();
            List outputFields = output.getOutputFields();
            block14: for (Object outputField : outputFields) {
                DerivedOutputField derivedField = encoder.createDerivedField((Model)model, (OutputField)outputField, true);
                ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                ResultFeature resultFeature = outputField.getResultFeature();
                switch (resultFeature) {
                    case PREDICTED_VALUE: {
                        utilityFunctionFeatures.put(choice, (Feature)feature);
                        continue block14;
                    }
                    case TRANSFORMED_VALUE: {
                        expUtilityFunctionFeatures.put(choice, (Feature)feature);
                        continue block14;
                    }
                }
                throw new IllegalArgumentException();
            }
            outputFields.clear();
        }
        switch (modelType) {
            case "MNL": {
                break;
            }
            case "NL": {
                RFunctionCall nlNests = this.nlNests;
                Map<?, RFunctionCall> nlStructures = this.nlStructures;
                if (nlNests == null) {
                    throw new IllegalArgumentException("Invalid 'apollo_probabilities' element. Missing nest lambda parameters (variable 'nlNests')");
                }
                Map<?, Number> lambdas = MaxLikConverter.parseLambdas(nlNests, estimates);
                if (nlStructures.isEmpty()) {
                    throw new IllegalArgumentException("Invalid 'apollo_probabilities' element. Missing nest structure (variable 'nlStructure')");
                }
                ArrayList nestChoices = new ArrayList(nlStructures.keySet());
                Collections.reverse(nestChoices);
                LinkedHashMap nlTree = new LinkedHashMap();
                for (Object nestChoice : nestChoices) {
                    DerivedField derivedField;
                    Apply apply;
                    Number lambda = lambdas.get(nestChoice);
                    RFunctionCall functionCall = nlStructures.get(nestChoice);
                    Collection<?> childChoices = MaxLikConverter.parseVector(functionCall).values();
                    for (Object childChoice : childChoices) {
                        nlTree.put(childChoice, nestChoice);
                    }
                    if (availabilities != null) {
                        Object childChoice;
                        apply = ExpressionUtil.createApply((String)"sum", (Expression[])new Expression[0]);
                        childChoice = childChoices.iterator();
                        while (childChoice.hasNext()) {
                            Object childChoice2 = childChoice.next();
                            Feature availabilityFeature = availabilityFeatures.get(childChoice2);
                            apply.addExpressions(new Expression[]{availabilityFeature.ref()});
                        }
                        apply = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{apply, ExpressionUtil.createConstant((Number)0)}), ExpressionUtil.createConstant((Number)1), ExpressionUtil.createConstant((Number)0)});
                        derivedField = encoder.createDerivedField(FieldNameUtil.create((String)"availability", (Object[])new Object[]{nestChoice}), OpType.CONTINUOUS, DataType.INTEGER, (Expression)apply);
                        ContinuousFeature availabilityfeature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                        availabilityFeatures.put((String)nestChoice, (Feature)availabilityfeature);
                    }
                    apply = ExpressionUtil.createApply((String)"sum", (Expression[])new Expression[0]);
                    for (Object childChoice2 : childChoices) {
                        FieldRef expression;
                        if (lambda.doubleValue() != 1.0) {
                            Feature feature = (Feature)utilityFunctionFeatures.get(childChoice2);
                            expression = ExpressionUtil.createApply((String)"exp", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{feature.ref(), ExpressionUtil.createConstant((Number)lambda)})});
                        } else {
                            Feature expFeature = (Feature)expUtilityFunctionFeatures.get(childChoice2);
                            expression = expFeature.ref();
                        }
                        if (availabilities != null) {
                            Feature availabilityFeature = availabilityFeatures.get(childChoice2);
                            expression = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{availabilityFeature.ref(), expression});
                        }
                        apply.addExpressions(new Expression[]{expression});
                    }
                    apply = ExpressionUtil.createApply((String)"ln", (Expression[])new Expression[]{apply});
                    if (lambda.doubleValue() != 1.0) {
                        apply = ExpressionUtil.createApply((String)"*", (Expression[])new Expression[]{apply, ExpressionUtil.createConstant((Number)lambda)});
                    }
                    derivedField = encoder.createDerivedField(FieldNameUtil.create((String)"utility", (Object[])new Object[]{nestChoice}), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
                    ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                    utilityFunctionFeatures.put(nestChoice, (Feature)feature);
                    Apply expApply = ExpressionUtil.createApply((String)"exp", (Expression[])new Expression[]{feature.ref()});
                    DerivedField expDerivedField = encoder.createDerivedField(FieldNameUtil.create((String)"exp", (Object[])new Object[]{feature}), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expApply);
                    ContinuousFeature expFeature = new ContinuousFeature((PMMLEncoder)encoder, (Field)expDerivedField);
                    expUtilityFunctionFeatures.put(nestChoice, (Feature)expFeature);
                }
                this.lambdas = lambdas;
                Extension extension = this.encodeNlStructures(nlTree);
                choiceField.addExtensions(new Extension[]{extension});
                this.nlTree = nlTree;
                break;
            }
            default: {
                throw new IllegalArgumentException(modelType);
            }
        }
        this.availabilityFeatures = availabilityFeatures;
        this.utilityFunctionFeatures = utilityFunctionFeatures;
        this.expUtilityFunctionFeatures = expUtilityFunctionFeatures;
    }

    @Override
    public Model encodeModel(Schema schema) {
        RGenericVector maxLik = (RGenericVector)this.getObject();
        RStringVector modelTypeList = maxLik.getStringElement("modelTypeList");
        String modelType = modelTypeList.getValue(0);
        ModelEncoder encoder = schema.getEncoder();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        Map<?, Feature> availabilityFeatures = this.availabilityFeatures;
        Map<?, Feature> utilityFunctionFeatures = this.utilityFunctionFeatures;
        Map<?, Feature> expUtilityFunctionFeatures = this.expUtilityFunctionFeatures;
        ArrayList<RegressionTable> regressionTables = new ArrayList<RegressionTable>();
        switch (modelType) {
            case "MNL": {
                for (int i = 0; i < categoricalLabel.size(); ++i) {
                    Object choice = categoricalLabel.getValue(i);
                    Feature feature = expUtilityFunctionFeatures.get(choice);
                    if (availabilityFeatures != null && !availabilityFeatures.isEmpty()) {
                        Feature availabilityFeature = availabilityFeatures.get(choice);
                        feature = new InteractionFeature((PMMLEncoder)encoder, FieldNameUtil.create((String)"interaction", (Object[])new Object[]{availabilityFeature, feature}), DataType.DOUBLE, Arrays.asList(availabilityFeature, feature));
                    }
                    RegressionTable regressionTable = RegressionModelUtil.createRegressionTable(Collections.singletonList(feature), Collections.singletonList(1.0), null).setTargetCategory(choice);
                    regressionTables.add(regressionTable);
                }
                break;
            }
            case "NL": {
                Map<?, Number> lambdas = this.lambdas;
                Map<?, ?> nlTree = this.nlTree;
                for (int i = 0; i < categoricalLabel.size(); ++i) {
                    Expression expression;
                    Object choice = categoricalLabel.getValue(i);
                    ArrayList<FieldRef> expressions = new ArrayList<FieldRef>();
                    Object currentChoice = choice;
                    Object nextChoice = nlTree.get(currentChoice);
                    while (nextChoice != null) {
                        Number lambda = lambdas.get(nextChoice);
                        Feature currentFeature = expUtilityFunctionFeatures.get(currentChoice);
                        Feature nextFeature = expUtilityFunctionFeatures.get(nextChoice);
                        DerivedField derivedField = encoder.ensureDerivedField(FieldNameUtil.create((String)"decisionFunction", (Object[])new Object[]{currentChoice, nextChoice}), OpType.CONTINUOUS, DataType.DOUBLE, () -> {
                            Apply expression = ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{ExpressionUtil.createApply((String)"equal", (Expression[])new Expression[]{nextFeature.ref(), ExpressionUtil.createConstant((Number)0.0)}), ExpressionUtil.createConstant((Number)0.0), ExpressionUtil.createApply((String)"/", (Expression[])new Expression[]{currentFeature.ref(), nextFeature.ref()})});
                            if (lambda.doubleValue() != 1.0) {
                                expression = ExpressionUtil.createApply((String)"pow", (Expression[])new Expression[]{expression, ExpressionUtil.createConstant((Number)(1.0 / lambda.doubleValue()))});
                            }
                            return expression;
                        });
                        expressions.add(new FieldRef((Field)derivedField));
                        currentChoice = nextChoice;
                        nextChoice = nlTree.get(currentChoice);
                    }
                    if (expressions.size() == 1) {
                        expression = (Expression)Iterables.getOnlyElement(expressions);
                    } else {
                        Apply apply = ExpressionUtil.createApply((String)"product", (Expression[])new Expression[0]);
                        apply.getExpressions().addAll(expressions);
                        expression = apply;
                    }
                    DerivedField derivedField = encoder.createDerivedField(FieldNameUtil.create((String)"decisionFunction", (Object[])new Object[]{choice}), OpType.CONTINUOUS, DataType.DOUBLE, expression);
                    ContinuousFeature feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                    if (availabilityFeatures != null && !availabilityFeatures.isEmpty()) {
                        Feature availabilityFeature = availabilityFeatures.get(choice);
                        feature = new InteractionFeature((PMMLEncoder)encoder, FieldNameUtil.create((String)"interaction", (Object[])new Object[]{availabilityFeature, feature}), DataType.DOUBLE, Arrays.asList(availabilityFeature, feature));
                    }
                    RegressionTable regressionTable = RegressionModelUtil.createRegressionTable(Collections.singletonList(feature), Collections.singletonList(1.0), null).setTargetCategory(choice);
                    regressionTables.add(regressionTable);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(modelType);
            }
        }
        RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)categoricalLabel), regressionTables).setNormalizationMethod(RegressionModel.NormalizationMethod.SIMPLEMAX).setOutput(ModelUtil.createProbabilityOutput((DataType)DataType.DOUBLE, (DiscreteLabel)categoricalLabel));
        return regressionModel;
    }

    private RegressionModel encodeUtilityFunction(Object choice, RFunctionCall functionCall, Map<String, RExp> variables, Map<String, Double> estimates, RExpEncoder encoder) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<Number> coefficients = new ArrayList<Number>();
        this.encodeTerm(choice, functionCall, 1, variables, estimates, features, coefficients, encoder);
        RegressionModel regressionModel = new RegressionModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema(null), null).setNormalizationMethod(RegressionModel.NormalizationMethod.NONE).addRegressionTables(new RegressionTable[]{RegressionModelUtil.createRegressionTable(features, coefficients, null)}).setOutput(ModelUtil.createPredictedOutput((String)FieldNameUtil.create((String)"utility", (Object[])new Object[]{choice}), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{new ExpTransformation()}));
        return regressionModel;
    }

    private void encodeTerm(Object choice, RExp rexp, int sign, Map<String, RExp> variables, Map<String, Double> estimates, List<Feature> features, List<Number> coefficients, RExpEncoder encoder) {
        ContinuousFeature feature;
        Expression expression;
        RFunctionCall functionCall;
        RString string;
        if (rexp instanceof RFunctionCall) {
            RFunctionCall functionCall2 = (RFunctionCall)rexp;
            if (functionCall2.hasValue("+")) {
                Iterator<RExp> it = functionCall2.argumentValues();
                this.encodeTerm(choice, it.next(), 1, variables, estimates, features, coefficients, encoder);
                this.encodeTerm(choice, it.next(), 1, variables, estimates, features, coefficients, encoder);
                return;
            }
            if (functionCall2.hasValue("-")) {
                Iterator<RExp> it = functionCall2.argumentValues();
                this.encodeTerm(choice, it.next(), 1, variables, estimates, features, coefficients, encoder);
                this.encodeTerm(choice, it.next(), -1, variables, estimates, features, coefficients, encoder);
                return;
            }
        } else if (rexp instanceof RString && estimates.containsKey((string = (RString)rexp).getValue())) {
            Number beta = estimates.get(string.getValue());
            features.add((Feature)new ConstantFeature((PMMLEncoder)encoder, beta));
            coefficients.add(sign);
            return;
        }
        Number coefficient = null;
        if (rexp instanceof RFunctionCall && (functionCall = (RFunctionCall)rexp).hasValue("*")) {
            RString string2;
            Iterator<RExp> it = functionCall.argumentValues();
            RExp firstArgValue = it.next();
            RExp secondArgValue = it.next();
            if (firstArgValue instanceof RString && estimates.containsKey((string2 = (RString)firstArgValue).getValue())) {
                coefficient = estimates.get(string2.getValue());
                rexp = secondArgValue;
            }
        }
        if ((expression = MaxLikConverter.toPMML(rexp, variables, estimates, encoder)) instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            Field field = encoder.getField(fieldRef.requireField());
            feature = new ContinuousFeature((PMMLEncoder)encoder, field);
        } else {
            DerivedField derivedField = encoder.createDerivedField(FieldNameUtil.create((String)"term", (Object[])new Object[]{choice, features.size()}), OpType.CONTINUOUS, DataType.DOUBLE, expression);
            feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
        }
        coefficient = coefficient != null ? (Number)ValueUtil.multiply((MathContext)MathContext.DOUBLE, (Number)sign, (Number)coefficient) : (Number)sign;
        features.add((Feature)feature);
        coefficients.add(coefficient);
    }

    private Extension encodeNlStructures(Map<?, ?> nlTree) {
        LinkedHashMap data = new LinkedHashMap();
        ArrayList parents = new ArrayList();
        ArrayList children = new ArrayList();
        nlTree.entrySet().stream().forEach(entry -> {
            parents.add(entry.getValue());
            children.add(entry.getKey());
        });
        if (!parents.isEmpty() && Objects.equals(parents.get(parents.size() - 1), "root")) {
            Collections.reverse(parents);
            Collections.reverse(children);
        }
        data.put("parent", parents);
        data.put("child", children);
        InlineTable inlineTable = PMMLUtil.createInlineTable(data);
        return PMMLUtil.createExtension((String)"nlStructures", (Object[])new Object[]{inlineTable});
    }

    private void parseApolloProbabilities() {
        RGenericVector maxLik = (RGenericVector)this.getObject();
        RClosure apolloProbabilities = (RClosure)maxLik.getElement("apollo_probabilities");
        RFunctionCall body = (RFunctionCall)apolloProbabilities.getBody();
        if (!body.hasValue("{")) {
            throw new IllegalArgumentException();
        }
        RFunctionCall settings = null;
        LinkedHashMap<String, RExp> variables = new LinkedHashMap<String, RExp>();
        LinkedHashMap utilityFunctions = new LinkedHashMap();
        RFunctionCall nlNests = null;
        LinkedHashMap nlStructures = new LinkedHashMap();
        Iterator<RExp> it = body.argumentValues();
        while (it.hasNext()) {
            RExp argValue = it.next();
            if (argValue instanceof RFunctionCall) {
                RFunctionCall functionCall = (RFunctionCall)argValue;
                if (!functionCall.hasValue("=") && !functionCall.hasValue("<-")) continue;
                Iterator<RExp> it2 = functionCall.argumentValues();
                RExp firstArgValue = it2.next();
                RExp secondArgValue = it2.next();
                if (firstArgValue instanceof RString) {
                    RString string = (RString)firstArgValue;
                    if (MaxLikConverter.matchVariable(firstArgValue, "mnl_settings") || MaxLikConverter.matchVariable(firstArgValue, "nl_settings")) {
                        settings = (RFunctionCall)secondArgValue;
                        continue;
                    }
                    if (MaxLikConverter.matchVariable(firstArgValue, "nlNests")) {
                        nlNests = (RFunctionCall)secondArgValue;
                        continue;
                    }
                    variables.put(string.getValue(), secondArgValue);
                    continue;
                }
                if (!(firstArgValue instanceof RFunctionCall)) continue;
                Object choice = MaxLikConverter.matchUtilityFunction(firstArgValue);
                if (choice != null) {
                    utilityFunctions.put(choice, (RFunctionCall)secondArgValue);
                    continue;
                }
                choice = MaxLikConverter.matchNLStructure(firstArgValue);
                if (choice == null) continue;
                nlStructures.put(choice, (RFunctionCall)secondArgValue);
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.settings = settings;
        this.variables = variables;
        this.utilityFunctions = utilityFunctions;
        this.nlNests = nlNests;
        this.nlStructures = nlStructures;
    }

    private static boolean matchVariable(RExp argValue, String variableName) {
        if (argValue instanceof RString) {
            RString string = (RString)argValue;
            return Objects.equals(variableName, string.getValue());
        }
        return false;
    }

    private static Object matchUtilityFunction(RExp argValue) {
        return MaxLikConverter.matchListAssignment(argValue, "V");
    }

    private static Object matchNLStructure(RExp argValue) {
        return MaxLikConverter.matchListAssignment(argValue, "nlStructure");
    }

    private static Object matchListAssignment(RExp argValue, String variableName) {
        RExp secondArgValue;
        RString string;
        Iterator<RExp> it;
        RExp firstArgValue;
        RFunctionCall functionCall;
        if (argValue instanceof RFunctionCall && (functionCall = (RFunctionCall)argValue).hasValue("[[") && (firstArgValue = (it = functionCall.argumentValues()).next()) instanceof RString && Objects.equals(variableName, (string = (RString)firstArgValue).getValue()) && (secondArgValue = it.next()) instanceof RVector) {
            RVector vector = (RVector)secondArgValue;
            return vector.asScalar();
        }
        return null;
    }

    private static Expression toPMML(RExp argumentValue, Map<String, RExp> variables, Map<String, Double> estimates, RExpEncoder encoder) {
        if (argumentValue instanceof RString) {
            Field field;
            RString string = (RString)argumentValue;
            String stringValue = string.getValue();
            if (estimates.containsKey(stringValue)) {
                return ExpressionUtil.createConstant((Number)estimates.get(stringValue));
            }
            try {
                field = encoder.getField(stringValue);
            }
            catch (IllegalArgumentException iae) {
                if (variables.containsKey(stringValue)) {
                    Expression expression = MaxLikConverter.toPMML(variables.get(stringValue), variables, estimates, encoder);
                    field = encoder.createDerivedField(stringValue, OpType.CONTINUOUS, DataType.DOUBLE, expression);
                }
                field = encoder.createDataField(stringValue, OpType.CONTINUOUS, DataType.DOUBLE);
            }
            return new FieldRef(field);
        }
        if (argumentValue instanceof RNumberVector) {
            RNumberVector numberVector = (RNumberVector)argumentValue;
            return ExpressionUtil.createConstant((Number)((Number)numberVector.asScalar()));
        }
        if (argumentValue instanceof RFunctionCall) {
            RFunctionCall functionCall = (RFunctionCall)argumentValue;
            RString value = (RString)functionCall.getValue();
            Iterator<RExp> it = functionCall.argumentValues();
            switch (value.getValue()) {
                case "(": {
                    return MaxLikConverter.toPMML(it.next(), variables, estimates, encoder);
                }
                case "+": 
                case "-": 
                case "*": 
                case "/": {
                    return MaxLikConverter.toBinaryExpression(value.getValue(), it, variables, estimates, encoder);
                }
                case "^": {
                    return MaxLikConverter.toBinaryExpression("pow", it, variables, estimates, encoder);
                }
                case "==": {
                    return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{MaxLikConverter.toBinaryExpression("equal", it, variables, estimates, encoder), ExpressionUtil.createConstant((Number)1.0), ExpressionUtil.createConstant((Number)0.0)});
                }
                case "!=": {
                    return ExpressionUtil.createApply((String)"if", (Expression[])new Expression[]{MaxLikConverter.toBinaryExpression("notEqual", it, variables, estimates, encoder), ExpressionUtil.createConstant((Number)1.0), ExpressionUtil.createConstant((Number)0.0)});
                }
            }
            throw new IllegalArgumentException(value.getValue());
        }
        throw new IllegalArgumentException();
    }

    private static Apply toBinaryExpression(String function, Iterator<RExp> it, Map<String, RExp> variables, Map<String, Double> estimates, RExpEncoder encoder) {
        return ExpressionUtil.createApply((String)function, (Expression[])new Expression[]{MaxLikConverter.toPMML(it.next(), variables, estimates, encoder), MaxLikConverter.toPMML(it.next(), variables, estimates, encoder)});
    }

    private static Map<?, Number> parseLambdas(RFunctionCall functionCall, final Map<String, Double> estimates) {
        Function<RExp, Number> function = new Function<RExp, Number>(){

            @Override
            public Number apply(RExp rexp) {
                if (rexp instanceof RString) {
                    RString string = (RString)rexp;
                    return (Number)estimates.get(string.getValue());
                }
                if (rexp instanceof RNumberVector) {
                    RNumberVector numberVector = (RNumberVector)rexp;
                    return (Number)numberVector.asScalar();
                }
                throw new IllegalArgumentException();
            }
        };
        return MaxLikConverter.parseList(functionCall, function);
    }

    private static <V> Map<String, V> parseList(RFunctionCall functionCall, Function<RExp, V> function) {
        if (!functionCall.hasValue("list")) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, V> result = new LinkedHashMap<String, V>();
        Iterator<RPair> it = functionCall.arguments();
        while (it.hasNext()) {
            RPair arg = it.next();
            RString tag = (RString)arg.getTag();
            RExp value = arg.getValue();
            result.put(tag.getValue(), function.apply(value));
        }
        return result;
    }

    private static Map<?, ?> parseVector(RFunctionCall functionCall) {
        if (!functionCall.hasValue("c")) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap result = new LinkedHashMap();
        Iterator<RPair> it = functionCall.arguments();
        while (it.hasNext()) {
            RPair arg = it.next();
            RString tag = (RString)arg.getTag();
            RExp value = arg.getValue();
            if (value instanceof RVector) {
                RVector vector = (RVector)value;
                if (tag != null) {
                    result.put(tag.getValue(), vector.asScalar());
                    continue;
                }
                result.put(result.size() + 1, vector.asScalar());
                continue;
            }
            throw new IllegalArgumentException();
        }
        return result;
    }
}

