/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PredicateManager;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.xgboost.RegTree;

public abstract class ObjFunction {
    public abstract Label encodeLabel(FieldName var1, List<?> var2, PMMLEncoder var3);

    public abstract MiningModel encodeMiningModel(List<RegTree> var1, List<Float> var2, float var3, Integer var4, Schema var5);

    protected static MiningModel createMiningModel(List<RegTree> trees, List<Float> weights, float base_score, Integer ntreeLimit, Schema schema) {
        if (weights != null && trees.size() != weights.size()) {
            throw new IllegalArgumentException();
        }
        ContinuousLabel continuousLabel = (ContinuousLabel)schema.getLabel();
        Schema segmentSchema = schema.toAnonymousSchema();
        PredicateManager predicateManager = new PredicateManager();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        if (ntreeLimit != null) {
            if (ntreeLimit > trees.size()) {
                throw new IllegalArgumentException("Tree limit " + ntreeLimit + " is greater than the number of trees");
            }
            trees = trees.subList(0, ntreeLimit);
            if (weights != null) {
                weights = weights.subList(0, ntreeLimit);
            }
        }
        for (RegTree tree : trees) {
            TreeModel treeModel = tree.encodeTreeModel(predicateManager, segmentSchema);
            treeModels.add(treeModel);
        }
        if (weights != null) {
            boolean allOnes = true;
            for (Float weight : weights) {
                allOnes &= ValueUtil.isOne((Number)weight);
            }
            if (allOnes) {
                weights = null;
            }
        }
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Label)continuousLabel)).setMathContext(MathContext.FLOAT).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)(weights != null ? Segmentation.MultipleModelMethod.WEIGHTED_SUM : Segmentation.MultipleModelMethod.SUM), treeModels, weights)).setTargets(ModelUtil.createRescaleTargets(null, (Number)Float.valueOf(base_score), (ContinuousLabel)continuousLabel));
        return miningModel;
    }
}

