% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-traits.R
\docType{class}
\name{traits-class}
\alias{traits-class}
\title{An S4 class to represent a set of PGS Catalog Traits}
\description{
The traits object consists of six slots, each a table
(\code{\link[tibble]{tibble}}), that combined form a relational database of a
subset of PGS Catalog traits. Each trait is an observation (row) in
the \code{traits} table --- main table. All tables have the column
\code{efo_id} as primary key.
}
\section{Slots}{

\describe{
\item{\code{traits}}{A table of traits. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{trait}{Trait name.}
\item{description}{Detailed description of the trait from EFO.}
\item{url}{External link to the EFO entry.}
}}

\item{\code{pgs_ids}}{A table of associated polygenic score identifiers. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{pgs_id}{Polygenic Score (PGS) identifier.}
}}

\item{\code{child_pgs_ids}}{A table of polygenic score identifiers associated with
the child traits. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{child_pgs_id}{Polygenic Score (PGS) identifiers associated with child traits.}
}}

\item{\code{trait_categories}}{A table of associated trait categories. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{trait_category}{Trait category name.}
}}

\item{\code{trait_synonyms}}{A table of associated trait synonyms. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{trait_synonyms}{Trait synonyms.}
}}

\item{\code{trait_mapped_terms}}{A table of associated external references,
identifiers or other terms. Columns:
\describe{
\item{efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier.}
\item{parent_efo_id}{An \href{https://www.ebi.ac.uk/efo/}{EFO} identifier of
the parent trait.}
\item{is_child}{Is this trait obtained because it is a child of other trait?}
\item{trait_mapped_terms}{Trait mapped terms.}
}}
}}

