% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{thresholds}
\alias{thresholds}
\title{Calculates the thresholds}
\usage{
thresholds(qp, prob = NULL, log = FALSE)
}
\arguments{
\item{qp}{output from quickpsy}

\item{prob}{Probability to calculate the threshold.}

\item{log}{Use \code{TRUE}, if the logarithm of the independent variable
has been used to fit the curves (default is \code{FALSE}).}
}
\description{
\code{thresholds} alculates the thresholds
}
\examples{
library(MPDiR) # contains the Vernier data
data(Vernier) # ?Venier for the reference
fit <- quickpsy(Vernier, Phaseshift, NumUpward, N,
                grouping = .(Direction, WaveForm, TempFreq), B =20,
                thresholds = FALSE)
thresholds(fit, prob = .5)
}

