% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi.R
\name{zi}
\alias{zi}
\title{Zooms in on current plot}
\usage{
zi(qmap_obj = NULL, zoom_perc = 0.5, loc = NULL)
}
\arguments{
\item{qmap_obj}{A qmap object.  Optional, but performs better with larger 
data sets.}

\item{zoom_perc}{A proportion to determine the zoom level.  The x and y 
axes are reduced by this amount.  Default is 0.5.}

\item{loc}{A list with an x and y numeric indicating a location.  Default is 
to interactively get loc value until escaped.}
}
\description{
Interactively zoom in on the current plot. Works on an existing
 \code{qmap} object.  Simply pass that object to \code{zi()}.  A single zoom in 
 results and the extent of the
\code{qmap} object is changed.
}
\examples{
\dontrun{
data(lake)
x<-qmap(list(lake,buffer,elev))
zi(x)
}
}

