% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.R
\name{i}
\alias{i}
\title{Identify}
\usage{
i(qmap_obj = NULL, i_idx = 1, loc = NULL)
}
\arguments{
\item{qmap_obj}{a \code{qmap} object from which to identify features.}

\item{i_idx}{a numeric value specifying which data layer to identify or a 
character string indicating the name of the layer. Defaults to 1.}

\item{loc}{A list with an x and y numeric indicating a location.  Default is 
to interactively get loc value until escaped.}
}
\value{
Returns NULL.  Identified values are printed to the screen.
}
\description{
Interactively select an \code{sp} or \code{raster} object and print the 
data associated with it. \code{i()} only accepts a single input point.
}
\examples{
\dontrun{
data(lake)
qm<-qmap(list(lake,elev,samples))
i(qm,"lake")
i(qm,"samples")
i(qm,2)
}
}

