% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-classes.R
\docType{class}
\name{.quickPlot-class}
\alias{.quickPlot-class}
\alias{.quickPlot}
\title{The \code{.quickPlot} class}
\description{
This class contains all necessary information to build a Plot on a device,
except the actual data. Thus, this class differs notably from the grid package,
which keeps a copy of all data *and* information in a hidden location for further
access for rebuilding, erasing etc. This difference allows the Plot function to
be much faster than using the grid methodology directly. The cost to this speed
gain is that the objects *must* be available, by name, in the .GlobalEnv.
}
\details{
This class contains two slots, one for the overall arrangement of the plots within
the device window, and the second for all the \code{\link{.quickPlotGrob}} objects within
that device window. These \code{\link{.quickPlotGrob}} objects are the individual
"smallest" plot unit.

These \code{gp*} parameters will specify plot parameters that are
available with \code{gpar()}. \code{gp} will adjust plot parameters,
\code{gpText} will adjust title and legend text, \code{gpAxis} will
adjust the axes. \code{size} adjusts point size in a
\code{SpatialPoints} object. These will persist with the
original \code{Plot} call for each individual object. Multiple
entries can be used, but they must be named list elements
and they must match the \code{...} items to plot. This is true
for a RasterStack also, i.e., the list of named elements
must be the same length as the number of layers being
plotted. The naming convention used is: \code{RasterStackName$layerName},
i.e, \code{landscape$DEM}.
}
\section{Slots}{

\describe{
\item{\code{arr}}{An .arrangement object}

\item{\code{quickPlotGrobList}}{list. A list of lists of .quickPlotGrob objects}
}}

\seealso{
\code{\link{quickPlotClasses}}
}
\author{
Eliot McIntire
}
\keyword{internal}
