% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggsurvey.R
\name{ggsurvey}
\alias{ggsurvey}
\title{Easy ggplot2 with survey objects}
\usage{
ggsurvey(design = NULL, mapping = NULL, ...)
}
\arguments{
\item{design}{A survey design object, usually created with
\code{\link[survey:svydesign]{survey::svydesign()}}}

\item{mapping}{Default list of aesthetic mappings to use for plot,
to be created with \code{\link[ggplot2:aes]{ggplot2::aes()}}.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\description{
A function to facilitate \code{ggplot2} graphs using a survey object.
It will initiate a ggplot and map survey weights to the
corresponding aesthetic.
}
\details{
Graphs will be correct as long as only weights are required
to compute the graph. However, statistic or geometry requiring
correct variance computation (like
\code{\link[ggplot2:geom_smooth]{ggplot2::geom_smooth()}}) will
be statistically incorrect.
}
\examples{
if (require(survey) & require(ggplot2)) {
  data(api)
  dstrat <- svydesign(
    id = ~1, strata = ~stype,
    weights = ~pw, data = apistrat,
    fpc = ~fpc
  )
  ggsurvey(dstrat) +
    aes(x = cnum, y = dnum) +
    geom_count()

  d <- as.data.frame(Titanic)
  dw <- svydesign(ids = ~1, weights = ~Freq, data = d)
  ggsurvey(dw) +
    aes(x = Class, fill = Survived) +
    geom_bar(position = "fill")
}
}
