% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\docType{package}
\name{quest}
\alias{quest}
\title{Pre-processing Questionnaire Data}
\description{
\code{quest} is a package for pre-processing questionnaire data
  to get it ready for statistical modeling. It contains functions for
  investigating missing data (e.g., \code{rowNA}), reshaping data (e.g.,
  \code{wide2long}), validating responses (e.g., \code{revalids}), recoding
  variables (e.g., \code{recodes}), scoring (e.g., \code{scores}), centering
  (e.g., \code{centers}), aggregating (e.g., \code{aggs}), shifting (e.g.,
  \code{shifts}), etc. Functions whose first phrases end with an \code{s} are
  vectorized versions of their functions without an \code{s} at the end of
  the first phrase. For example, \code{center} inputs a (atomic) vector and
  outputs a atomic vector to center and/or scale a single variable;
  \code{centers} inputs a data.frame and outputs a data.frame to center
  and/or scale multiple variables. Functions that end in \code{_by} are
  calculated by group. For example, \code{center} does grand-mean centering
  while \code{center_by} does group-mean centering. Putting the two together,
  \code{centers_by} inputs a data.frame and outputs a data.frame to center
  and/or scale multiple variables by group. Functions that end in \code{_if}
  are calculated dependent on the frequency of observed values (aka amount of
  missing data). The \code{quest} package uses the \code{str2str} package
  internally to convert R objects from one structure to another. See
  \code{\link{str2str}} for details.
}
\section{Types of functions}{
 There are two main types of functions. 1) Helper
  functions that primarily exist to save a few lines of code and are
  primarily for convenience (e.g., \code{vecNA}). 2) Functions for wrangling
  questionnaire data (e.g., \code{nom2dum}, \code{reverses}).
}

\section{Abbreviations}{
 \describe{See the table below
   \item{nm}{names}
   \item{ov}{observed values}
   \item{NA}{missing values}
   \item{prop}{proportion}
   \item{sep}{separator}
   \item{vrb}{variable}
   \item{grp}{group}
   \item{id}{identifier}
   \item{rtn}{return}
   \item{fun}{function}
   \item{dfm}{data.frame}
   \item{fct}{factor}
   \item{nom}{nominal variable}
   \item{dum}{dummy variable}
   \item{pomp}{percentage of maximum possible}
   \item{std}{standardize}
   \item{wth}{within-groups}
   \item{btw}{between-groups}
}
}

