% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/Class-SmoothedPG.R
\docType{methods}
\name{plot-SmoothedPG}
\alias{plot,SmoothedPG,ANY-method}
\alias{plot-SmoothedPG}
\title{Plot the values of a \code{\link{SmoothedPG}}.}
\usage{
\S4method{plot}{SmoothedPG,ANY}(x, plotPG = FALSE, qsd, ptw.CIs = 0.1,
  type.CIs = c("naive.sd", "boot.sd", "boot.full"), ratio = 3/2,
  widthlab = lcm(1), xlab = expression(omega/2 * pi), ylab = NULL,
  type.scaling = c("individual", "real-imaginary", "all"),
  frequencies = x@frequencies, levels = intersect(x@levels[[1]],
  x@levels[[2]]))
}
\arguments{
\item{x}{The \code{\link{SmoothedPG}} object to plot}

\item{plotPG}{a flag indicating weater the \code{QuantilePG} object
associated with the \code{\link{SmoothedPG}} \code{x}
is also to be plotted.}

\item{qsd}{a \code{\link{QuantileSD}} object; will be plotted if not
missing.}

\item{ptw.CIs}{the confidence level for the confidence intervals to be
displayed; must be a number from [0,1]; if null, then no
confidence intervals will be plotted.}

\item{type.CIs}{indicates the method to be used for determining the
confidence intervals; the methods available are those
 provided by
\code{\link{getPointwiseCIs-SmoothedPG}}.}

\item{ratio}{quotient of width over height of the subplots; use this
parameter to produce landscape or portrait shaped plots.}

\item{widthlab}{width for the labels (left and bottom); default is
\code{lcm(1)}, cf. \code{\link[graphics]{layout}}.}

\item{xlab}{label that will be shown on the bottom of the plots; can be
an expression (for formulas), characters or \code{NULL} to
force omission (to save space).}

\item{ylab}{label that will be shown on the left side of the plots;
can be an expression (for formulas), characters or
\code{NULL} to force omission (to save space).}

\item{type.scaling}{a method for scaling of the subplots; currently there
are three options: \code{"individual"} will scale each of the
\code{K^2} subplots to minimum and maximum of the values
in that plot, \code{"real-imaginary"} will scale each of the
subplots displaying real parts and each of the subplots
displaying imaginary parts to the minimum and maximum of
the values display in these subportion of plots. The
option \code{"all"} will scale the subplots to the minimum and
maximum in all of the subplots.}

\item{frequencies}{a set of frequencies for which the values are to be
plotted.}

\item{levels}{a set of levels for which the values are to be plotted.}
}
\value{
Returns the plot described in the Description section.
}
\description{
Creates a \code{K} x \code{K} plot depicting a smoothed quantile periodogram.
Optionally, the quantile periodogram on which the smoothing was performed,
a simulated quantile spectral density, and pointwise confidence intervals can
be displayed.
In each of the subplots either the real part (on and below the diagonal;
i. e., \eqn{\tau_1 \leq \tau_2}{tau1 <= tau2}) or the imaginary parts
(above the diagonal; i. e., \eqn{\tau_1 > \tau_2}{tau1 > tau2}) of
\itemize{
  \item the smoothed quantile periodogram (blue line),
  \item the quanitle peridogram that was used for smoothing (gray line),
  \item a simulated quantile spectral density (red line),
  \item pointwise (asymptotic) confidence intervals (light gray area),
}
for the combination of levels \eqn{\tau_1}{tau1} and \eqn{\tau_2}{tau2}
denoted on the left and bottom margin of the plot are displayed.
}

