% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{resample}
\alias{resample}
\title{Sample a vector}
\usage{
resample(x, size = NULL, replace = FALSE, prob = NULL, by = NULL)
}
\arguments{
\item{x}{numeric vector}

\item{size}{the number of items to sample within each group, as a positive
number or a vector of numbers equal in length to the number of groups. If
\code{NULL}, the sampling is stratified by group in the original group
sizes.}

\item{replace}{if \code{TRUE}, sample with replacement}

\item{prob}{a vector of probability weights for values in \code{x}}

\item{by}{a grouping vector equal in length to \code{length(x)}}
}
\value{
\code{x} resampled within groups
}
\description{
Return a sample from a vector within a grouping variable if specified.
}
\examples{
set.seed(100)
grvec <- c(rep("a", 3), rep("b", 4), rep("c", 3))
quanteda:::resample(1:10, replace = FALSE, by = grvec)
quanteda:::resample(1:10, replace = TRUE, by = grvec)
quanteda:::resample(1:10, size = 2, replace = TRUE, by = grvec)
quanteda:::resample(1:10, size = c(1, 1, 3), replace = TRUE, by = grvec)
}
\keyword{internal}
