% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimnames.R
\name{set_dfm_dimnames<-}
\alias{set_dfm_dimnames<-}
\alias{set_dfm_docnames<-}
\alias{set_dfm_featnames<-}
\alias{set_fcm_dimnames<-}
\alias{set_fcm_featnames<-}
\title{Internal functions to set dimnames}
\usage{
set_dfm_dimnames(x) <- value

set_dfm_docnames(x) <- value

set_dfm_featnames(x) <- value

set_fcm_dimnames(x) <- value

set_fcm_featnames(x) <- value
}
\arguments{
\item{x}{\link{dfm} or \link{fcm}}

\item{value}{character a vector for docnames or featnames or a list of them
for dimnames}
}
\description{
Default \code{dimnames()} converts a zero-length character vector to NULL,
leading to the improper functioning of subsetting functions. These are safer
methods to set the dimnames of a dfm or fcm object.
}
\examples{
dfmat <- dfm(tokens(c("a a b b c", "b b b c")))
quanteda:::set_dfm_featnames(dfmat) <- paste0("feature", 1:3)
quanteda:::set_dfm_docnames(dfmat) <- paste0("DOC", 1:2)
quanteda:::set_dfm_dimnames(dfmat) <- list(c("docA", "docB"), LETTERS[1:3])
}
\keyword{internal}
