% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textstat-methods.R
\name{textstat_select}
\alias{textstat_select}
\title{Select rows of textstat objects by glob, regex or fixed patterns}
\usage{
textstat_select(x, pattern = NULL, selection = c("keep", "remove"),
  valuetype = c("glob", "regex", "fixed"), case_insensitive = TRUE)
}
\arguments{
\item{x}{a \code{textstat} object}

\item{pattern}{a character vector, list of character vectors,
\link{dictionary}, or \link{collocations} object.  See \link{pattern} for
details.}

\item{selection}{whether to \code{"keep"} or \code{"remove"} the rows that
match the pattern}

\item{valuetype}{the type of pattern matching: \code{"glob"} for 
"glob"-style wildcard expressions; \code{"regex"} for regular expressions;
or \code{"fixed"} for exact matching. See \link{valuetype} for details.}

\item{case_insensitive}{ignore case when matching, if \code{TRUE}}
}
\description{
Users can subset output object of \code{textstat_collocations},
\code{textstat_keyness} or \code{textstat_frequency} based on
\code{"glob"}, \code{"regex"} or \code{"fixed"} patterns using this method.
}
\examples{
period <- ifelse(docvars(data_corpus_inaugural, "Year") < 1945, "pre-war", "post-war")
dfmat <- dfm(data_corpus_inaugural, groups = period)
tstat <- textstat_keyness(dfmat)
textstat_select(tstat, 'america*')

}
\keyword{internal}
\keyword{textstat}
