% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sample_bygroup}
\alias{sample_bygroup}
\title{Sample a vector by a group}
\usage{
sample_bygroup(x, group, replace = FALSE)
}
\arguments{
\item{x}{any vector}

\item{group}{a grouping vector equal in length to \code{length(x)}}

\item{replace}{logical; should sampling be with replacement?}
}
\value{
\code{x} resampled within groups
}
\description{
Return a sample from a vector within a grouping variable.
}
\examples{
set.seed(100)
grvec <- c(rep("a", 3), rep("b", 4), rep("c", 3))
quanteda:::sample_bygroup(1:10, group = grvec, replace = FALSE)
quanteda:::sample_bygroup(1:10, group = grvec, replace = TRUE)
}
\keyword{internal}
