% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{as.yaml}
\alias{as.yaml}
\title{convert quanteda dictionary objects to the YAML format}
\usage{
as.yaml(x)
}
\arguments{
\item{x}{dictionary object}
}
\value{
\code{as.yaml} returns a dictionary in the YAML format
}
\description{
Converts a \pkg{quanteda} dictionary object constructed by the 
\link{dictionary} function into the YAML format. The YAML 
files can be editied in text editors and imported into 
\pkg{quanteda} again.
}
\examples{
\dontrun{
dict <- dictionary(file = '/home/kohei/Documents/Dictionary/LaverGarry.txt', format = 'wordstat')
yaml <- as.yaml(dict)
cat(yaml, file = '/home/kohei/Documents/Dictionary/LaverGarry.yaml')
}
}
