% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collocations.R
\name{collocations}
\alias{collocations}
\alias{collocations.character}
\alias{collocations.corpus}
\alias{collocations.tokenizedTexts}
\title{Detect collocations from text}
\usage{
collocations(x, ...)

\method{collocations}{corpus}(x, method = c("lr", "chi2", "pmi", "dice",
  "all"), size = 2, n = NULL, toLower = TRUE,
  punctuation = c("dontspan", "ignore", "include"), ...)

\method{collocations}{character}(x, method = c("lr", "chi2", "pmi", "dice",
  "all"), size = 2, n = NULL, toLower = TRUE,
  punctuation = c("dontspan", "ignore", "include"), ...)

\method{collocations}{tokenizedTexts}(x, method = c("lr", "chi2", "pmi",
  "dice", "all"), size = 2, n = NULL, toLower = FALSE,
  punctuation = c("dontspan", "ignore", "include"), ...)
}
\arguments{
\item{x}{a text, a character vector of texts, or a corpus}

\item{...}{additional parameters passed to \code{\link{tokenize}}}

\item{method}{association measure for detecting collocations.  Let \eqn{i} 
index documents, and \eqn{j} index features, \eqn{n_{ij}} refers to 
observed counts, and \eqn{m_{ij}} the expected counts in a collocations 
frequency table of dimensions \eqn{(J - size + 1)^2}. Available measures 
are computed as: \describe{ \item{\code{"lr"}}{The likelihood ratio 
statistic \eqn{G^2}, computed as: \deqn{2 * \sum_i \sum_j ( n_{ij} * log 
\frac{n_{ij}}{m_{ij}} )} } \item{\code{"chi2"}}{Pearson's \eqn{\chi^2} 
statistic, computed as: \deqn{\sum_i \sum_j \frac{(n_{ij} - 
m_{ij})^2}{m_{ij}}} } \item{\code{"pmi"}}{point-wise mutual information 
score, computed as log \eqn{n_{11}/m_{11}}} \item{\code{"dice"}}{the Dice 
coefficient, computed as \eqn{n_{11}/n_{1.} + n_{.1}}} 
\item{\code{"all"}}{returns all of the above} }}

\item{size}{length of the collocation.  Only bigram (\code{n=2}) and trigram 
(\code{n=3}) collocations are currently implemented.  Can be \code{c(2,3)}
(or \code{2:3}) to return both bi- and tri-gram collocations.}

\item{n}{the number of collocations to return, sorted in descending order of 
the requested statistic, or \eqn{G^2} if none is specified.}

\item{toLower}{convert collocations to lower case if \code{TRUE} (default)}

\item{punctuation}{how to handle tokens separated by punctuation characters.  Options are:
\describe{
\item{\code{dontspan}}{do not form collocations from tokens separated by punctuation characters (default)}
\item{\code{ignore}}{ignore punctuation characters when forming collocations, meaning that collocations will 
include those separated by punctuation characters in the text.  The punctuation characters themselves are not
returned.}
\item{\code{include}}{do not treat punctuation characters specially, meaning that collocations will include
punctuation characters as tokens}
}}
}
\value{
A data.table of collocations, their frequencies, and the computed 
  association measure(s).
}
\description{
Detects collocations from texts or a corpus, returning a data.frame of
collocations and their scores, sorted in descending order of the association
measure.  Words separated by punctuation delimiters are not counted by
default (\code{spanPunct = FALSE})  as adjacent and hence are not eligible to
be collocations.
}
\examples{
txt <- c("This is software testing: looking for (word) pairs!  
         This [is] a software testing again. For.",
         "Here: this is more Software Testing, looking again for word pairs.")
collocations(txt, punctuation = "dontspan") # default
collocations(txt, punctuation = "dontspan", removePunct = TRUE)  # includes "testing looking"
collocations(txt, punctuation = "ignore", removePunct = TRUE)    # same as previous 
collocations(txt, punctuation = "include", removePunct = FALSE)  # keep punctuation as tokens

collocations(txt, size = 2:3)
removeFeatures(collocations(txt, size = 2:3), stopwords("english"))

collocations("@textasdata We really, really love the #quanteda package - thanks!!")
collocations("@textasdata We really, really love the #quanteda package - thanks!!",
              removeTwitter = TRUE)

collocations(inaugTexts[49:57], n = 10)
collocations(inaugTexts[49:57], method = "all", n = 10)
collocations(inaugTexts[49:57], method = "chi2", size = 3, n = 10)
collocations(subset(inaugCorpus, Year>1980), method = "pmi", size = 3, n = 10)
}
\author{
Kenneth Benoit
}
\references{
McInnes, B T. 2004. "Extending the Log Likelihood Measure to 
  Improve Collocation Identification."  M.Sc. Thesis, University of 
  Minnesota.
}
\seealso{
\link{ngrams}
}

