% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/stopwords.R
\docType{data}
\name{stopwords}
\alias{.stopwords}
\alias{stopwords}
\alias{stopwordsGet}
\title{access built-in stopwords}
\usage{
stopwords(kind = "english", verbose = FALSE)

stopwordsGet(kind = "english")
}
\arguments{
\item{kind}{The pre-set kind of stopwords (as a character string).  Allowed
values are \code{english}, \code{SMART}, \code{danish}, \code{french},
\code{hungarian}, \code{norwegian}, \code{russian}, \code{swedish},
\code{catalan}, \code{dutch}, \code{finnish}, \code{german},
\code{italian}, \code{portuguese}, \code{spanish}, \code{arabic}}

\item{verbose}{if \code{FALSE}, suppress the annoying warning note}
}
\value{
a character vector of stopwords
}
\description{
This function retrieves stopwords from the type specified in the \code{kind}
argument and returns the stopword list as a character vector The default is
English.
}
\details{
The stopword list are SMART English stopwords from the SMART information
retrieval system (obtained from
http://jmlr.csail.mit.edu/papers/volume5/lewis04a/a11-smart-stop-list/english.stop)
and a set of stopword lists from the Snowball stemmer project in different
languages (obtained from
http://svn.tartarus.org/snowball/trunk/website/algorithms/*/stop.txt).
Supported languages are arabic, danish, dutch, english, finnish, french,
german, hungarian, italian, norwegian, portuguese, russian, spanish, and
swedish. Language names are case sensitive.
}
\section{A note of caution}{

 Stop words are an arbitrary choice imposed by the
  user, and accessing a pre-defined list of words to ignore does not mean
  that it will perfectly fit your needs. You are strongly encourged to
  inspect the list and to make sure it fits your particular requirements.
}
\examples{
stopwords("english")[1:5]
stopwords("italian")[1:5]
stopwords("arabic")[1:5]
}

