% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dfm-main.R
\docType{methods}
\name{trim}
\alias{trim}
\alias{trim,dfm-method}
\alias{trimdfm}
\title{Trim a dfm using threshold-based or random feature selection}
\usage{
trim(x, minCount = 1, minDoc = 1, nsample = NULL, verbose = TRUE)

\S4method{trim}{dfm}(x, minCount = 1, minDoc = 1, nsample = NULL,
  verbose = TRUE)

trimdfm(x, ...)
}
\arguments{
\item{x}{document-feature matrix of \link{dfm-class}}

\item{minCount}{minimum feature count}

\item{minDoc}{minimum number of documents in which a feature appears}

\item{nsample}{how many features to retain (based on random selection)}

\item{verbose}{print messages}

\item{...}{only included to allow legacy \code{trimdfm} to pass arguments to \code{trim}}
}
\value{
A \link{dfm-class} object reduced in features
}
\description{
Returns a document by feature matrix reduced in size based on document and term frequency, and/or subsampling.
}
\examples{
dtm <- dfm(inaugCorpus)
dim(dtm)
dtmReduced <- trim(dtm, minCount=10, minDoc=2) # only words occuring >=5 times and in >=2 docs
dim(dtmReduced)
topfeatures(dtmReduced, decreasing=FALSE)
dtmSampled <- trim(dtm, minCount=20, nsample=50)  # sample 50 words over 20 count
dtmSampled # 57 x 50 words
topfeatures(dtmSampled)
}
\author{
Ken Benoit, inspired by code by Will Lowe (see \code{trim} from the \code{austin} package)
}

