% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpinfo_to_map.R
\name{snpinfo_to_map}
\alias{snpinfo_to_map}
\title{Convert SNP info to map}
\usage{
snpinfo_to_map(snpinfo)
}
\arguments{
\item{snpinfo}{Data frame with SNP information with the following
    columns (the last three are generally derived from with
    \code{\link[qtl2]{index_snps}}):
\itemize{
\item \code{chr} - Character string or factor with chromosome
\item \code{pos} - Position (in same units as in the \code{"map"}
    attribute in \code{genoprobs}.
\item \code{sdp} - Strain distribution pattern: an integer, between
    1 and \eqn{2^n - 2} where \eqn{n} is the number of strains, whose
    binary encoding indicates the founder genotypes
\item \code{snp} - Character string with SNP identifier (if
    missing, the rownames are used).
\item \code{index} - Indices that indicate equivalent
    groups of SNPs.
\item \code{intervals} - Indexes that indicate which marker
    intervals the SNPs reside.
\item \code{on_map} - Indicate whether SNP coincides with a marker
    in the \code{genoprobs}
}}
}
\value{
map as list of vectors of marker positions.
}
\description{
Convert SNP info to map
}
