% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_snpinfo.R
\name{create_snpinfo}
\alias{create_snpinfo}
\title{Create snp information table for a cross}
\usage{
create_snpinfo(cross)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}
}
\value{
A data frame of SNP information with the following columns:
\itemize{
\item \code{chr} - Character string or factor with chromosome
\item \code{pos} - Position (in same units as in the \code{"map"}
attribute in \code{genoprobs}.
\item \code{snp} - Character string with SNP identifier (if
missing, the rownames are used).
\item \code{sdp} - Strain distribution pattern: an integer, between
1 and \eqn{2^n - 2} where \eqn{n} is the number of strains, whose
binary encoding indicates the founder genotypes
SNPs with missing founder genotypes are omitted.
}
}
\description{
Create a table of snp information from a cross, for use with \code{\link[=scan1snps]{scan1snps()}}.
}
\examples{
\dontrun{
# load example data and calculate genotype probabilities
file <- paste0("https://raw.githubusercontent.com/rqtl/",
               "qtl2data/main/DO_Recla/recla.zip")
recla <- read_cross2(file)
snpinfo <- create_snpinfo(recla)

# calculate genotype probabilities
pr <- calc_genoprob(recla, error_prob=0.002, map_function="c-f")

# index the snp information
snpinfo <- index_snps(recla$pmap, snpinfo)

# sex covariate
sex <- setNames((recla$covar$Sex=="female")*1, rownames(recla$covar))

# perform a SNP scan
out <- scan1snps(pr, recla$pmap, recla$pheno[,"bw"], addcovar=sex, snpinfo=snpinfo)

# plot the LOD scores
plot(out$lod, snpinfo, altcol="green3")
}

}
\seealso{
\code{\link[=index_snps]{index_snps()}}, \code{\link[=scan1snps]{scan1snps()}}, \code{\link[=genoprob_to_snpprob]{genoprob_to_snpprob()}}
}
