% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_scan1.R
\name{clean_scan1}
\alias{clean_scan1}
\alias{clean.scan1}
\title{Clean scan1 output}
\usage{
clean_scan1(object, ...)

\method{clean}{scan1}(object, ...)
}
\arguments{
\item{object}{Output of \code{\link[=scan1]{scan1()}}.}

\item{...}{Ignored at present}
}
\value{
The input object with negative values replaced with NAs and then rows with all NAs removed.
}
\description{
Clean scan1 output by replacing negative values with NA and remove
rows where all values are NA.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
\dontshow{iron <- iron[,"2"]}
pr <- calc_genoprob(iron)
out <- scan1(pr, iron$pheno)

out <- clean(out)
}
