% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/qte.R
\name{CiC}
\alias{CiC}
\title{Change in Changes}
\usage{
CiC(formla, t, tmin1, tname, x = NULL, data, dropalwaystreated = TRUE,
  panel = FALSE, plot = FALSE, se = TRUE, idname = NULL,
  uniqueid = NULL, alp = 0.05, probs = seq(0.05, 0.95, 0.05),
  iters = 100, seedvec = NULL, printIter = F)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary)}

\item{t}{The 3rd time period in the sample (this is the name of the column)}

\item{tmin1}{The 2nd time period in the sample (this is the name of the
column)}

\item{tname}{The name of the column containing the time periods}

\item{x}{A vector of covariates (the name of the columns)}

\item{data}{The name of the data.frame that contains the data}

\item{dropalwaystreated}{How to handle always treated observations
in panel data case (not currently used)}

\item{panel}{Binary variable indicating whether or not the dataset is
panel.  This is used for computing bootstrap standard errors correctly.}

\item{plot}{Boolean whether or not the estimated QTET should be plotted}

\item{se}{Boolean whether or not to compute standard errors}

\item{idname}{The individual (cross-sectional unit) id name}

\item{uniqueid}{Not sure if this is used anymore}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{seedvec}{Optional value to set random seed; can possibly be used
 in conjunction with bootstrapping standard errors.}

\item{printIter}{Boolean only used for debugging}
}
\value{
QTE Object
}
\description{
\code{CiC} computes the Quantile Treatment Effect on the
 Treated (QTET) using the method of Athey and Imbens (2006).  \code{CiC}
 is a Difference in Differences type method.  It requires
 having two periods of data that can be either  repeated cross sections
 or panel data.

The method can accommodate conditioning on covariates though it does so
in a restrictive way:  It specifies a linear model for outcomes conditional
on group-time dummies and covariates.  Then, after residualizing (see details
in Athey and Imbens (2006)), it computes the Change in Changes model
based on these quasi-residuals.
}
\examples{
## load the data
data(lalonde)

## Run the Change in Changes model conditioning on age, education,
## black, hispanic, married, and nodegree
c1 <- CiC(re ~ treat, t=1978, tmin1=1975, tname="year",
 x=c("age","education","black","hispanic","married","nodegree"),
 data=lalonde.psid.panel, idname="id", se=FALSE,
 probs=seq(0.05, 0.95, 0.05))
summary(c1)
}
\references{
Athey, Susan and Guido Imbens.  ``Identification and Inference in Nonlinear
 Difference-in-Differences Models.'' Econometrica 74.2, pp. 431-497,
 2006.
}

