% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsavem-load.R
\name{qsavem}
\alias{qsavem}
\title{qsavem}
\usage{
qsavem(...)
}
\arguments{
\item{...}{Objects to serialize. Named arguments will be passed to \code{\link[=qsave]{qsave()}} during saving. Un-named arguments will be saved. A named \code{file} argument is required.}
}
\description{
Saves (serializes) multiple objects to disk.
}
\details{
This function extends \code{\link[=qsave]{qsave()}} to replicate the functionality of \code{\link[base:save]{base::save()}} to save multiple objects. Read them back with \code{\link[=qload]{qload()}}.
}
\examples{
x1 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
x2 <- data.frame(int = sample(1e3, replace=TRUE),
                 num = rnorm(1e3),
                 char = sample(starnames$`IAU Name`, 1e3, replace=TRUE),
                 stringsAsFactors = FALSE)
myfile <- tempfile()
qsavem(x1, x2, file=myfile)
rm(x1, x2)
qload(myfile)
exists('x1') && exists('x2') # returns true

# qs support multithreading
qsavem(x1, x2, file=myfile, nthreads=2)
rm(x1, x2)
qload(myfile, nthreads=2)
exists('x1') && exists('x2') # returns true
}
