% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{qattributes}
\alias{qattributes}
\title{qattributes}
\usage{
qattributes(file, use_alt_rep=FALSE, strict=FALSE, nthreads=1)
}
\arguments{
\item{file}{The file name/path.}

\item{use_alt_rep}{Use ALTREP when reading in string data (default \code{FALSE}). On R versions prior to 3.5.0, this parameter does nothing.}

\item{strict}{Whether to throw an error or just report a warning (default: \code{FALSE}, i.e. report warning).}

\item{nthreads}{Number of threads to use. Default \code{1}.}
}
\value{
the attributes fo the serialized object.
}
\description{
Reads the attributes of an object serialized to disk.
}
\details{
Equivalent to:

\code{attributes(qread(file))}

But more efficient. Attributes are stored towards the end of the file.
This function will read through
the contents of the file (without de-serializing the object itself),
and then de-serializes the attributes only.

Because it is necessary to read through the file, pulling out attributes could
take a long time if the file is large. However, it should be much faster than
de-serializing the entire object first.
}
\examples{

file <- tempfile()
qsave(mtcars, file)

attr1 <- qattributes(file)
attr2 <- attributes(qread(file))

print(attr1)
# $names
# [1] "IAU Name"      "Designation"   "Const." ...

# $row.names
# [1] 1 2 3 4 5
# $class
# [1] "data.frame"

identical(attr1, attr2) # TRUE

}
