% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_files.R
\name{qs_use_alt_rep}
\alias{qs_use_alt_rep}
\title{Use alt-rep}
\usage{
qs_use_alt_rep(s)
}
\arguments{
\item{s}{A boolean to determine whether `qread` uses alt-rep.  Default: TRUE.}
}
\description{
Changes whether qread uses the alt-rep system.  If you experience issues or run out of memory, set to FALSE.
}
\examples{
myfile <- tempfile()
qs_use_alt_rep(FALSE)
x <- randomStrings(1e3)
qsave(x, myfile)
x2 <- qread(myfile) # qs will no longer use alt-rep strings to load in character vector data
identical(x, x2) # returns true
}
