% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_new_functions.R
\name{field_label}
\alias{field_label}
\title{Create field plot labels embossed with QR codes}
\usage{
field_label(
  dat,
  get_unique_id = c("ruid", "uuid", "custom"),
  unique_id = NULL,
  filename = "PlotLabel",
  Year = NULL,
  rname = NULL,
  Trial = "PYT",
  seed_source = FALSE,
  IBlock = FALSE,
  rep_id = "REP",
  plot_id = "PLOT",
  row_id = "ROW",
  col_id = "COLUMN",
  loc_id = "LOCATION",
  entry_id = "TREATMENT",
  IBlock_id = "IBLOCK",
  seed_source_id = NULL,
  ...
)
}
\arguments{
\item{dat}{An input data frame of field book that contains plot attributes.
To design field plot labels, the imported field book must have LOCATION, PLOT,
ROW, COLUMN/RANGE, REP, TREATMENT columns. The order of the columns in the field book
is not important, and the columns can be any name the user desires.}

\item{get_unique_id}{Set to 'ruid' if reproducible and informative unique ids
are to be generated from imported field book. Set to 'uuid' if universal unique ids
are to be generated from imported field book. Set to 'custom' if imported field book
already has unique IDs for each plot.}

\item{unique_id}{The column identifier for UNIQUE_ID in the imported field book.}

\item{filename}{A character prefix or path for the pdf file to be created. Default path
is working directory.}

\item{Year}{The year of experiment or trial.}

\item{rname}{The researcher's name. Initials or initials of first and middle
names and the last name.}

\item{Trial}{The name of the trial to use.}

\item{seed_source}{Set to TRUE if seed source is included in the imported field book,
FALSE if otherwise.}

\item{IBlock}{Set to TRUE if \code{dat} contains incomplete blocks within replications.}

\item{rep_id}{The column identifier for REP in the imported field book.}

\item{plot_id}{The column identifier for PLOT in the imported field book.}

\item{row_id}{The column identifier for ROW in the imported field book.}

\item{col_id}{The column identifier for COLUMN in the imported field book.}

\item{loc_id}{The column identifier for LOCATION in the imported field book.}

\item{entry_id}{The column identifier for ENTRY/TREATMENT in the imported field book.}

\item{IBlock_id}{The column identifier for IBLOCK in the imported field book.
It must be provided if \code{IBlock} is set to TRUE.}

\item{seed_source_id}{The column identifier for SEED_SOURCE in the imported field book.
It must be provided if \code{seed_source} is set to TRUE.}

\item{...}{Additional arguments passed to the \code{create_label()} function.}
}
\value{
A PDF file containing field plot labels affixed with QR codes, and a
 data frame of an updated field book; all saved to the default or working directory.
}
\description{
Create machine- and human-readable plot labels that are well-suited for field experiments.
}
\details{
The default column identifiers for LOCATION, PLOT, ROW, COLUMN/RANGE, REP, TREATMENT
are based on the column IDs of a field book generated using the 'FielDHub' package.
If user imports any field book generated with other programs,
the user must specify the equivalent column identifiers used for LOCATION, PLOT, REP,
ROW, COLUMN, and TREATMENT/ENTRY in the imported field book.

if \code{get_unique_id = 'ruid'} (i.e. Reproducible Unique IDs), the function concatenates
location, year, trial name, plot, row and column IDs. if \code{get_unique_id = 'uuid'} 
(i.e. Universal Unique IDs), the function generates UUIDs by time randomly. 
Note that UUIDs are uninformative and not reproducible.

If input field book already has unique IDs for each plot, the \code{get_unique_id} 
argument should be set to 'custom'; and the \code{unique_id}
argument must be specified as a string using the column name in the input field book
that denotes plot unique IDs.

if \code{Year} is NULL, the function uses the current year as defined in the `sys.time()`.

If the user is printing labels for any incomplete block design, the imported
field book must include an IBLOCK column if the users wishes to display intra-blocking
information for experimental plots on the label.

Set the \code{IBlock} argument to TRUE if the field layout has incomplete
blocks within replications. The imported  field book must include an IBLOCK column if
the \code{IBlock} argument is set to TRUE.
}
\examples{

library(qrlabelr)
df <- data.frame(LOCATION = rep("BAMBEY", 5),
                PLOT = 1001:1005,
                ROW = c(rep(1, 3), rep(2, 2)),
                COLUMN = c(1:3, 1:2),
                REP = rep(1, 5),
                IBLOCK = c(rep(1, 3), rep(2, 2)),
                TREATMENT = paste0("G-", 1:5),
                SEED_SOURCE = rep("OFF_NUR", 5))
df$ids <- paste0(df$LOCATION,'2023', '_PYT', '_', df$PLOT, '_', df$ROW, '_',
                 df$COLUMN)
file <- tempfile()
\donttest{
if(file.exists(file)) 
field_label(
  dat = df,
  wdt = 5, 
  hgt = 2,
  page_wdt = 8.5, 
  page_hgt = 11,
  top_mar = 0.75, 
  bot_mar = 0.75, 
  left_mar = 1.75, 
  right_mar = 1.75, 
  numrow = 4L, 
  numcol = 1L, 
  filename = file, 
  font_sz = 20, 
  Trial = "PYT", 
  Year = 2023, 
  family = "sans", 
  rounded = TRUE, 
  IBlock = TRUE,
  get_unique_id = "ruid", 
  rname = "AW Kena", 
  seed_source = TRUE, 
  seed_source_id = "SEED_SOURCE",
  ec_level = 1)
 }

}
\seealso{
\code{\link{create_label}} and \code{\link{gp_label}}
}
