% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{makecnote}
\alias{makecnote}
\title{makecnote}
\usage{
makecnote(
  x,
  label = paste0("`", deparse(substitute(x)), "`"),
  wide = FALSE,
  type = c("print", "run", "cat"),
  ...
)
}
\arguments{
\item{x}{an object having a suitable \code{print} method}

\item{label}{a character string providing a title for the tab.  Default is the name of the argument passed to \code{makecnote}.}

\item{wide}{set to \code{TRUE} to expand the width of the text body}

\item{type}{default is to \code{print}; can also be \code{run}, \code{cat}}

\item{...}{an optional list of arguments to be passed to \code{print}}
}
\value{
nothing is returned, used for rendering markup
}
\description{
Print an Object in a Collapsible Note
}
\details{
Prints an object in a Quarto collapsible note.
}
\examples{
makecnote('This is some text', label='mylab', wide=TRUE)
}
\author{
Frank Harrell
}
