% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{makecallout}
\alias{makecallout}
\title{makecallout}
\usage{
makecallout(...)
}
\arguments{
\item{...}{can be any of the following
\itemize{
\item x object to print (if \code{type='print'}), or one or more formulas whose right hand sides are to be run.  Left side provides labels if needed by the particular callout, and if \code{raw} is included on the right side any R code chunk run will have \code{results='asis'} in the chunk header.
\item callout character string giving the Quarto callout
\item label character string label if needed and if not obtained from the left side of a formula
\item type defaults to \code{'print'} to print an object.  Set to \code{'run'} to run a chunk or \code{'cat'} to use \code{cat()} to render.
\item now set to \code{FALSE} to return code instead of running it
\item results if not using formulas, specifies the formatting option to code in the code header, either \code{'asis'} (the default) or \code{'markup'}
\item close specifies whether to close the callout or to leave it open for future calls
\item parameters passed to \code{print}
}}
}
\value{
if code is not executed, returns a character vector with the code to run
}
\description{
General Case Handling of Quarto Callouts
}
\details{
This function generates and optionally runs markdown/R code that runs Quarto callouts such as collapsible notes or marginal notes.  Before rendering \code{x}, \code{options(rawmarkup=TRUE)} is set so that \code{Hmisc::rendHTML} will not try to protect html in things like margins.  Quarto doesn't like the surrounding html protection lines in that context.  The option is set back to its original value after rendering.
}
\examples{
x <- 1:3
co <- '.callout-note collapse="true'
makecallout(x, callout=co, label='# thislabel', type='print')
makecallout(thislabel ~ x, callout=co, type='print')
}
\author{
Frank Harrell
}
