% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.reg.r
\name{plot_reg}
\alias{plot_reg}
\title{Plot Regression Curves}
\usage{
plot_reg(
  x,
  by = character(0),
  th = NA,
  bloqvar = "bloq",
  timevar = "tad",
  depvar = "dv",
  timelab = "timevar",
  deplab = "depvar",
  exclvar = NA,
  plotdir = NA,
  ...
)
}
\arguments{
\item{x}{input dataset name}

\item{by}{column names in x indicating grouping variables}

\item{th}{file name of file with half-life estimation information for each curve}

\item{bloqvar}{variable name containing the BLOQ flag (0: no, 1: yes)}

\item{timevar}{variable name containing the actual sampling time after dose}

\item{depvar}{variable name containing the dependent variable (e.g., concentration)}

\item{timelab}{X-axis label (default: "timevar")}

\item{deplab}{Y-axis label (default: "depvar")}

\item{exclvar}{variable name containing information about points to be excluded (these should have exclvar = 1)}

\item{plotdir}{directory where individual plot files will be saved}

\item{...}{ignored}
}
\value{
(invisible) plotdir.  If the attribute 'plotdir' is empty, plots will be generated in standard output, otherwise plots will be saved as
PNG file in the designated directory.
}
\description{
Plots regression curves for each set of records defined using \code{by}.
A log-linear plot will be made for each curve.
}
\details{
If elimination half-life was estimated for that curve,
the following will be indicated in the plot:
\itemize{
\item Cmax (Yellow, even if no half-life was estimated)
\item points used in regression and resulting regression line (green)
\item points excluded from regression (red crossed)
\item estimate of elimination half-life and adjusted R-squared
}

Input dataset:
\itemize{
\item uncorrected dataset, used for half-life estimation
\item dataset containing results of the half-life estimation
}
}
\examples{
\donttest{
example(est.thalf)
x \%>\% filter(dv > 0) \%>\% plot_reg(by = 'subject', th = th)
}
}
