% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_events_quarter.R
\name{count_events_quarter}
\alias{count_events_quarter}
\title{Data frame of number of events occurring in each Lexis-diagram quarter}
\usage{
count_events_quarter(x)
}
\arguments{
\item{x}{A data.frame output of the \code{\link{quarterly_variables}} function.}
}
\value{
A data frame with the number of events for each (potential) combination of integer age and age and
season quarter of the input dataset. The data frame has the following components:
   \item{age}{ Integer age to which the time exposed at risk corresponds.}
   \item{quarter.age}{ Age quarter to which the time exposed at risk corresponds.}
   \item{quarter.calendar}{ Calendar (time, season) quarter to which the time exposed at risk corresponds.}
   \item{number.events}{ Number of events that occurred during the quarter determined for the
                        combination of `age`, `quarter.age` and `quarter.calendar`.}
}
\description{
Computes for each integer age and each combination of age and seasonal quarter
              the number of events occurring in the population.
              The computation is performed using the associated data frame of quarterly variables
              corresponding to the population obtained using the \code{\link{quarterly_variables}} function.
}
\note{
The structure of the dataset is similar to those obtained using the \code{\link{time_exposed_outs}},
\code{\link{time_exposed_ins}} and  \code{\link{time_exposed_stock}} functions.
}
\examples{
dates.b <- c("1920-05-13", "1999-04-12", "2019-01-01")
dates.e <- c("2002-03-23", "2009-04-12", "2019-01-01")
x <- quarterly_variables(dates.b, dates.e)
out <- count_events_quarter(x)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
