% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance.R
\name{setCovModel}
\alias{setCovModel}
\title{Set a covariance model}
\usage{
setCovModel(model = "sirfk", param = NULL, npoints = 0, var.sim = NULL,
  as.nugget = FALSE, nugget = 1e-04, trend = 2, fixed.param = NULL,
  lower = NULL, upper = NULL, ...)
}
\arguments{
\item{model}{name of covariance model}

\item{param}{numeric vector, \code{NULL} (default), starting values of covariance parameters for estimation}

\item{npoints}{number of sample points already evaluated for covariance parameter estimation}

\item{var.sim}{numeric vector, \code{NULL} (default), local simulation variances (so-called local nugget variances)}

\item{as.nugget}{logical, \code{FALSE} (default), whether to treat `\code{var.sim}` as
a fixed local nugget variance}

\item{nugget}{starting value for (global) nugget variance estimation}

\item{trend}{trend order ID: either linear (=1) or quadratic (=2) for polynomial trend terms}

\item{fixed.param}{vector of names, corresponding to `\code{param}` of covariance parameters, which are hold fixed for covariance
parameter estimation}

\item{lower}{lower bounds for REML estimation}

\item{upper}{upper bounds for REML estimation}

\item{...}{additional arguments which can be stored}
}
\value{
Object of class \code{covModel}
}
\description{
Set a covariance model for kriging the sample means of the involved statistics or for the variance matrix of the statistics.
}
\details{
The function defines a covariance model for kriging the sample mean values of an involved statistic. The covariance model
 (including a polynomial trend) defines the spatial dependence between different locations (points) of the
 parameter space. Currently, the function provides the generalized covariance models
 (`\code{sirfk}`, see \code{\link{fitSIRFk}}) of order \eqn{k=1,2} 
 and the Mat\eqn{\textrm{\'{e}}}rn covariance model with scale (or sill) parameter `\code{scale}`, smoothness parameter
 `\code{alpha}`, respectively, `\code{nu}`, and the range parameter `\code{rho}` defined only for the latter. A power exponential
 covariance model named "\code{powexp}" is also supported. 
 
 \subsection{Use of simulation variance}{
 If a vector of simulation variances is statically set by `\code{var.sim}` for each location these are used as (local)
 nugget variance estimations which account for the sampling variability due to the repeated measurements of the statistics
 by simulation. The length should match the number of locations/points `\code{npoints}` otherwise the given vector components
 are recycled. Setting `\code{as.nugget}` treats these values as fixed for all subsequent covariance model estimations. In addition,
 a global scalar valued nugget, which can captures the variance of the underlying random function, can be set by `\code{nugget}` as
 a starting value for the REML estimation procedure. Clearly, both types of nugget variances have a direct influence on the REML estimates.
 } 

 \subsection{Default parameters}{ 
 The default starting parameters are set to \code{("scale"=0.001,"alpha"=1.5)} for the `\code{sirfk}` model. The
 Mat\eqn{\textrm{\'{e}}}rn model uses the following parameters \code{("scale"=1.0,"nu"=2.5,"rho"=3.0)}. The default
 parameters for the power exponential covariance model are \code{"scale"=1.0}, (isotropic) range parameter
 \code{"phi"=1.0} and power \code{"kappa"=1.5} with \eqn{0<\kappa\leq 2}. 
 The corresponding lower and upper bounds are chosen such that the underlying random function remains
 twice continuously differentiable. Further, setting the names of the covariance parameters in `\code{fixed.param}`,
 excludes these parameters from subsequent REML estimations such that they remain unchanged. 

 The above settings are applicable for a wide range of statistics but, however, generally depend on the kind of statistics to be interpolated
 and thus have to be chosen carefully. Note that a valid (generalized) covariance model for kriging requires at least \eqn{q+2} design points
 for the trend order \eqn{k=1} and \eqn{1+(q+1)(q+2)/2} for \eqn{k=2} where \eqn{q} is the dimension of the unknown model parameter.
 }
}
\examples{
 # set the standards sirf-2 covariance model
 setCovModel("sirfk",npoints=12)

}
\author{
M. Baaske
}
