% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trc.R
\name{trc}
\alias{trc}
\title{Trellis run charts for multivariate data}
\usage{
trc(x, chart = c("run", "i"), xscale = "same", yscale = "same",
  dec = NULL, xpad = 0.1, pch = 20, cex = 0.7, gap = 0.5,
  target = NA, direction = NULL, ...)
}
\arguments{
\item{x}{Formula object to plot. The formula is of the form y ~ x | g1 + g2 +
..., indicating that plots of y (on the y-axis) versus x (on the x-axis)
should be produced conditional on the variables g1, g2.}

\item{chart}{Type of chart: 'run' or 'i'.}

\item{xscale}{Scaling of x-axes: 'same' or 'free'.}

\item{yscale}{Scaling of y-axes: 'same' or 'free'.}

\item{dec}{Number of decimals of median value. The default behaviour (smart
rounding to at least two significant digits) should be satisfactory in most
cases.}

\item{xpad}{Number specifying the fraction by which to extend the x-axis in
order to make space for the median label.}

\item{pch}{Plotting character.}

\item{cex}{Number indicating the magnification of plotting character.}

\item{gap}{Number indicating spacing between panels.}

\item{target}{Value specifying a target line to plot.}

\item{direction}{Value indication direction of improvement, 0 (down) or 1
(up).}

\item{...}{Further arguments to xyplot.}
}
\value{
Returns an object of class "trellis".
}
\description{
Run charts for multivariate data in trellis (grid) layout.
}
\details{
This function is a wrapper for \code{\link{xyplot}} from the
\code{\link{lattice}} package. Some usefull arguments from
\code{\link{xyplot}} are \code{main}, \code{ylab}, \code{xlab}, and
\code{layout}.
}
\examples{
# Trellis run chart on 1 conditioning variable
d1 <- data.frame(y = rnorm(96, 12, 3),
                 expand.grid(x = 1:24,
                             g = LETTERS[1:4]))
trc(y ~ x | g, data = d1, main = 'Trellis run chart')

# Add target line
trc(y ~ x | g, data = d1, main = 'Trellis run chart', target = 20)

# Trellis run chart on 2 conditioning variables
d2 <- data.frame(y = rnorm(144, 12, 3),
                 expand.grid(x = seq.Date(as.Date('2014-1-1'),
                                          by = 'week',
                                          length.out = 24),
                             g1 = LETTERS[1:3],
                             g2 = letters[1:2]))
trc(y ~ x | g1 + g2, data = d2, main = 'Trellis run chart')

# Introduce a shift in process performance
d2$y[132:144] <- d2$y[132:144] * 3
trc(y ~ x | g1 + g2, data = d2, main = 'Trellis run chart')

# Make I chart
trc(y ~ x | g1 + g2, data = d2, main = 'Trellis run chart', chart = 'i')
}
\seealso{
\code{\link{xyplot}}, \code{\link{qic}}
}

