% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compat-stars.R
\name{st_as_stars}
\alias{st_as_stars}
\alias{st_as_stars.qgis_outputRaster}
\alias{st_as_stars.qgis_outputLayer}
\alias{st_as_stars.qgis_result}
\title{Convert a qgis_result object or one of its elements to a stars object}
\usage{
\method{st_as_stars}{qgis_outputRaster}(x, ...)

\method{st_as_stars}{qgis_outputLayer}(x, ...)

\method{st_as_stars}{qgis_result}(x, ...)
}
\arguments{
\item{x}{A \code{qgis_result} object from \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}} or a
\verb{qgis_output*} object from one of the \code{\link[=qgis_extract_output]{qgis_extract_output()}} functions.}

\item{...}{Arguments passed to \code{\link[stars:read_stars]{stars::read_stars()}}.}
}
\value{
A \code{stars} or a \code{stars_proxy} object.
}
\description{
Convert a qgis_result object or one of its elements to a stars object
}
\details{
The stars package must be loaded explicitly to use these methods.
}
\examples{
\dontshow{if (has_qgis() && requireNamespace("stars", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# not running below examples in R CMD check to save time
result <- qgis_run_algorithm(
  "native:slope",
  INPUT = system.file("longlake/longlake_depth.tif", package = "qgisprocess")
)

# most direct approach, autoselecting a `qgis_outputRaster` type
# output from the `result` object and reading as stars or stars_proxy:
stars::st_as_stars(result)
stars::st_as_stars(result, proxy = TRUE)

# if you need more control, extract the needed output element first:
output_raster <- qgis_extract_output(result, "OUTPUT")
stars::st_as_stars(output_raster)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other topics about coercing processing output: 
\code{\link{qgis_as_raster}()},
\code{\link{qgis_as_terra}()},
\code{\link{st_as_sf}}

Other topics about accessing or managing processing results: 
\code{\link{qgis_as_raster}()},
\code{\link{qgis_as_terra}()},
\code{\link{qgis_clean_result}()},
\code{\link{qgis_extract_output}()},
\code{\link{qgis_result_status}()},
\code{\link{st_as_sf}}
}
\concept{topics about accessing or managing processing results}
\concept{topics about coercing processing output}
