% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-detect.R
\name{qgis_detect_windows_paths}
\alias{qgis_detect_windows_paths}
\alias{qgis_detect_macos_paths}
\title{Detect QGIS installations that provide the 'qgis_process' command}
\usage{
qgis_detect_windows_paths(drive_letter = strsplit(R.home(), ":")[[1]][1])

qgis_detect_macos_paths()
}
\arguments{
\item{drive_letter}{The drive letter on which to search. By default,
this is the same drive letter as the R executable.}
}
\value{
A character vector of possible paths to the 'qgis_process'
executable.
}
\description{
Discovers existing 'qgis_process' executables on the system and returns their
filepath.
Only available for Windows and macOS systems.
}
\note{
These functions do not verify whether the discovered 'qgis_process'
executables successfully run.
You can run \code{qgis_path(query = TRUE, quiet = FALSE)} to discover and cache
the first 'qgis_process' in the list that works.
}
\examples{
if (.Platform$OS.type == "windows") qgis_detect_windows_paths()
if (Sys.info()["sysname"] == "Darwin") qgis_detect_macos_paths()

}
\seealso{
\code{\link[=qgis_configure]{qgis_configure()}}, \code{\link[=qgis_path]{qgis_path()}}
}
\concept{functions to manage and explore QGIS and qgisprocess}
