% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgcomp_surv.R
\name{qgcomp.cox.boot}
\alias{qgcomp.cox.boot}
\title{estimation of quantile g-computation fit for a survival outcome}
\usage{
qgcomp.cox.boot(f, data, expnms = NULL, q = 4, breaks = NULL,
  B = 10, id = NULL, alpha = 0.05, ...)
}
\arguments{
\item{f}{R style formula}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that 
characterize the minimum value of each category for which to 
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{B}{Number of bootstrap iterations (default is 10)}

\item{id}{(optional) NULL, or variable name indexing individual units of 
observation (only needed if analyzing data with multiple observations per 
id/cluster)}

\item{alpha}{alpha level for confidence limit calculation}

\item{...}{arguments to glm (e.g. family)}
}
\value{
a qgcompfit object, which contains information about the effect
 measure of interest (psi) and associated variance (var.psi), as well
 as information on the model fit (fit) and information on the 
 weights/standardized coefficients in the positive (pweights) and 
 negative (nweight) directions.
}
\description{
This function performs quantile g-computation in a survival
setting.
}
\details{
For survival outcomes ...
}
\examples{
runif(1)
}
\seealso{
\code{\link[qgcomp]{qgcomp.boot}}, and \code{\link[qgcomp]{qgcomp}} 
 for time-fixed outcomes (cross-sectional or cohort design with outcomes measured
 at the end of follow-up)
}
\concept{variance mixtures}
