% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgs_funs.R
\name{hgs}
\alias{hgs}
\alias{hgs_1d}
\alias{hgs_2d}
\alias{hgs_3d}
\title{Calculate hypergeometric series}
\usage{
hgs_1d(dks, a1, b, lconst = 0)

hgs_2d(dks, a1, a2, b, lconst = 0)

hgs_3d(dks, a1, a2, a3, b, lconst = 0)
}
\arguments{
\item{dks}{\code{(m + 1)} vector for \eqn{d_{i}},
\code{(m + 1) * (m + 1)} square matrix for \eqn{d_{i, j}}, or
\code{(m + 1) * (m + 1) * (m + 1)} array for \eqn{d_{i, j, k}}
(\eqn{i, j, k = 0, 1, \dots m})}

\item{a1, a2, a3}{Numerator parameters}

\item{b}{Denominator parameter}

\item{lconst}{Scalar \eqn{\log c}}
}
\value{
Numeric with the same dimension with \code{dks}
}
\description{
These internal functions calculate (summands of) hypergeometric series.

\code{hgs_1d()} calculates the hypergeometric series
\eqn{c \frac{(a_1)_i}{(b)_i} d_{i}}

\code{hgs_2d()} calculates the hypergeometric series
\eqn{c \frac{(a_1)_i (a_2)_j}{(b)_{i+j}} d_{i, j}}

\code{hgs_3d()} calculates the hypergeometric series
\eqn{c \frac{(a_1)_i (a_2)_j (a_3)_k}{(b)_{i+j+k}} d_{i, j, k}}
}
\details{
The denominator parameter \code{b} is assumed positive,
whereas the numerator parameters can be positive or negative.
The signs of the latter will be reflected in the result.
}
