% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa3.1.R
\name{qdft2qper}
\alias{qdft2qper}
\title{Quantile Periodogram (QPER)}
\usage{
qdft2qper(y.qdft)
}
\arguments{
\item{y.qdft}{matrix or array of QDFT from \code{qdft()}}
}
\value{
matrix or array of quantile periodogram
}
\description{
This function computes quantile periodogram (QPER) from QDFT.
}
\examples{
# single time series
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.qdft <- qdft(y1,tau)
y.qper <- qdft2qper(y.qdft)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
qfa.plot(ff[sel.f],tau,Re(y.qper[sel.f,]))
# multiple time series
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y.qdft <- qdft(cbind(y1,y2),tau)
y.qper <- qdft2qper(y.qdft)
qfa.plot(ff[sel.f],tau,Re(y.qper[1,1,sel.f,]))
qfa.plot(ff[sel.f],tau,Re(y.qper[1,2,sel.f,]))
}
