% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_time2long.R
\name{cm_time2long}
\alias{cm_time2long}
\title{Transform Codes to Start-End Times}
\usage{
cm_time2long(..., v.name = "variable", list.var = TRUE, debug = TRUE,
  object = NULL)
}
\arguments{
\item{v.name}{An optional name for the column created for the list.var 
argument}

\item{list.var}{logical.  If \code{TRUE} creates a column for the data frame 
created by each time.list passed to \code{cm_t2l}.}

\item{debug}{logical. If \code{TRUE} debugging mode is on.
\code{\link[qdap]{cm_time2long}} will return possible errors in time span 
inputs.}

\item{object}{A list of list object(s) generated by 
\code{\link[qdap]{cm_time.temp}}.}

\item{\ldots}{List object(s) in the form generated by 
\code{\link[qdap]{cm_time.temp}}.}
}
\value{
Generates a dataframe of start and end times for each code.
}
\description{
Transforms the range coding structure(s) from \code{\link[qdap]{cm_time.temp}} 
(in list format) into a data frame of start and end times in long format.
}
\examples{
\dontrun{
x <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 
        9.00, 1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)
(dat <- cm_time2long(x))
plot(dat)

bar1 <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 16.25:17.01")
)

bar2 <- list(
    transcript_time_span = qcv(00:00 - 1:12:00),
    A = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00"),
    B = qcv(terms = "2.40, 3.01:3.02, 5.01, 6.02:7.00, 9.00,
        1.12.00:1.19.01"),
    C = qcv(terms = "2.40:3.00, 5.01, 6.02:7.00, 9.00, 17.01")
)

## General ldots Approach
cm_time2long(bar1)
cm_time2long(bar1, bar2, v.name="time")

## Specify `object` Approach
cm_time2long(object=list(bar1=bar1))
cm_time2long(object=list(bar1=bar1, bar2=bar2), v.name="time")
cm_time2long(object=list(a=bar1, b=bar2), v.name="time")
}
}
\references{
Miles, M. B. & Huberman, A. M. (1994). An expanded sourcebook: 
Qualitative   data analysis. 2nd ed. Thousand Oaks, CA: SAGE Publications.
}
\seealso{
\code{\link{cm_df2long}},
\code{\link{cm_time.temp}}
}
\keyword{coding,}
\keyword{time-span}
