% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_boot.R
\name{boot}
\alias{boot}
\title{Inference on QC-PM model paramters (i.e., loadings and path coefficients)}
\usage{
boot(qcpm, conf.level = 0.95, br = 200)
}
\arguments{
\item{qcpm}{is an  is an object of class \code{qcpm}}

\item{conf.level}{is the value used to fix the confidence level to use for the 
confidence interval. It is equal to 0.95 by default.}

\item{br}{specifies the number of bootstrap replications. It is fixed to 
\code{200} by default.}
}
\value{
\item{boot.loadings}{the outer loadings significance for each considered quantile.}

\item{boot.path}{the path coefficients significance for each considered 
quantile.}
}
\description{
The function \code{boot} returns in order the estimates, 
std. errors, t-values, p-values, and CI at a confidence level percent of loadings and the path 
coefficients for each quantile.
}
\details{
The argument \code{qcpm} is an  is an object of class \code{qcpm} 
returned by \code{\link{qcpm}} function. Std. errors are calculated by using the 
bootstrap method implemented by the  \code{tidy.rq} function of the broom package. When qcpm  
parameter \code{fix.quantile} is equal to \code{TRUE}, the function \code{boot} returns only 
loading results for the quantile 0.5.
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
# Structural model
EcoW ~ Edu
Health ~ Edu + EcoW

# Reflective measurement model
Edu =~ O22 + O23 + O24 + O25aa + O26 + O_27_28 + O_27_28_AA
EcoW =~ O41 + O44aa + O45 + O46aa + O42 + O43
Health =~  O11F + O11M + O12MEAN_aa
"

# Apply qcpm
well.qcpm = qcpm(model,province)
well.boot = boot(well.qcpm)   
well.boot 

}
\references{
Davino, C., Dolce, P., Taralli, S., Vistocco, D. (2020)  Composite-Based Path 
Modeling for Conditional Quantiles Prediction. An Application to Assess 
Health Differences at Local Level in a Well-Being Perspective. 
\emph{Social Indicator Research}, pp. 1-30, doi:10.1007/s11205-020-02425-5.

Davino, C., Vinzi, V.E. (2016) Quantile composite-based path
modeling. \emph{Advansed Data Analysis and Classification}, \bold{10}, pp. 
491-520, doi:10.1007/s11634-015-0231-9.

Dolce, P., Davino, C., Vistocco, D. (2021) Quantile composite-based path modeling: 
algorithms, properties and applications.\emph{Advansed Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.
}
\seealso{
\code{\link{qcpm}}, \code{\link{assessment}}, \code{\link{summary}}, and 
\code{\link{reliability}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
