% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_qad.R
\name{predict.qad}
\alias{predict.qad}
\title{Predict conditional probabilities}
\usage{
\method{predict}{qad}(
  object,
  values,
  conditioned = "x1",
  nr_intervals = NULL,
  prediction_interval = NULL,
  copula = FALSE,
  pred_plot = FALSE,
  panel.grid = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class 'qad', which determines the underlying checkerboard aggregation.}

\item{values}{a vector containing the x or the y values for which the conditional probabilities should be predicted.}

\item{conditioned}{a character specifying on which variable is conditioned. Options are "x1" (default) or "x2".}

\item{nr_intervals}{an integer, which determines a different number of intervals for the prediction (only possible in the copula setting).}

\item{prediction_interval}{a vector specifying the interval boundaries for which the conditional probability is computed. Options are NULL (default) to predict the conditional probabilities for all intervals or a vector c(lower boundary, upper boundary) indicating the boundaries.}

\item{copula}{a logical (default = FALSE) determining whether the empirical checkerboard copula is used or the retransformed data.}

\item{pred_plot}{a logical indicating if the conditional probabilities are plotted.}

\item{panel.grid}{a logical indicating whether the panel.grid is plotted.}

\item{...}{some methods for this generic require additional arguments.  None are used in this method.}
}
\value{
a list containing a data.frame with the computed intervals (lower and upper boundaries) and the prediction probabilities (i.e., the probability that Y lies in the interval Ii given X = x).
Furthermore, a heatmap depicting the mass of the conditional distribution functions is returned.
}
\description{
The function \code{predict.qad()} can be utilized to predict the probabilities of the event that Y lies in
specific intervals given X=x, or vice versa. Thereby, the intervals are calculated as retransformed intervals (by using the empirical quantil function) defining the checkerboard grid. Additionally, the mass of the conditional distribution functions are plotted.
The prediction can be computed in the sample setting as well as in the copula setting (pseudo-observation in the unit square).
}
\note{
Predictions are only possible for values within the range of the sample (or between 0 and 1 in the copula setting). For given values exceeding the range NA is returned.
}
\examples{
set.seed(1)
n <- 100
x <- runif(n, -4 ,4)
y <- x^2 + rnorm(n, 0, 1)
sample <- data.frame(x, y)

##(Not Run)
qad.fit <- qad(sample)
predict.qad(qad.fit, values = c(-2,0.6), conditioned = "x1", pred_plot = TRUE)
predict.qad(qad.fit, values = c(1,9), conditioned = "x2", pred_plot = TRUE)
predict.qad(qad.fit, values = c(-2,0.6), conditioned = "x1", pred_plot = FALSE,
        nr_intervals = 4)
predict.qad(qad.fit, values = c(-2,0.6), conditioned = "x1", pred_plot = FALSE,
            prediction_interval = c(4,6))
predict.qad(qad.fit, values = c(4,0.6), conditioned = "x2", pred_plot = FALSE,
            prediction_interval = c(2,3))

qad.pred <- predict.qad(qad.fit, values = c(-2,0.6), conditioned = "x1", pred_plot = FALSE)
qad.pred$prediction
qad.pred$plot


}
