% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetClient.R
\name{GetClient}
\alias{GetClient}
\alias{StartClient}
\alias{CheckAWSKeys}
\title{Creates an MTurk Client using the AWS SDK for Python (Boto3)}
\usage{
GetClient(sandbox = getOption("pyMTurkR.sandbox", TRUE),
  restart.client = FALSE)
}
\arguments{
\item{sandbox}{A logical indicating whether the client should be in the
sandbox environment or the live environment.}

\item{restart.client}{A boolean that specifies whether to force the creation of a new client.}
}
\description{
Create an API client. Only advanced users will likely need to use this
function. \code{CheckAWSKeys()} is a helper function that checks if your
AWS keys can be found.
}
\details{
\code{StartClient()} is an alias
}
\examples{
\dontrun{
GetClient()
}
}
\references{
\href{https://aws.amazon.com/sdk-for-python/}{AWS SDK for Python (Boto3)}
\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/mturk.html}{Boto3 Docs}
}
\author{
Tyler Burleigh
}
