% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra-functions.R
\name{rwiener}
\alias{rbridge}
\alias{rcumbin}
\alias{rwiener}
\title{Random process generators}
\usage{
rwiener(frequency = 1000, end = 1)

rbridge(frequency = 1000, end = 1)

rcumbin(frequency = 1000, end = 1)
}
\arguments{
\item{frequency}{a number specifying the size of trajectory vector. The trajectory will start at point 0 
and will have \code{frequency} more observations. The length of the results will be \code{frequency+1} .}

\item{end}{a number. The end point of the process in the 'time' scale.}
}
\value{
A time series containing a simulated realization of random processes. 
The length of time series is \code{frequency+1}, since zero is always included in the beginning of the sample.
}
\description{
Generate a trajectory of random processes.
}
\details{
\code{rwiener} generate Wiener process via partial sums process and 
\code{rbridge} generate Brownian bridge via \code{rwiener}.
The original code of \code{rwiener} and \code{rbridge} was written in the package \code{e1071}. 
In this package these functions was modified to
include leading zero in the beginning of the sample.

\code{rcumbin} generate partial sums process from random variables with values \code{-1,  0, 1}.
}

