% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{prepend}
\alias{prepend}
\title{Prepend a vector}
\usage{
prepend(x, values, before = 1)
}
\arguments{
\item{x}{the vector to be modified.}

\item{values}{to be included in the modified vector.}

\item{before}{a subscript, before which the values are to be appended.}
}
\value{
A merged vector.
}
\description{
This is a companion to \code{\link{append}()} to help merging two
lists or atomic vectors. \code{prepend()} is a clearer semantic
signal than `c()` that a vector is to be merged at the beginning of
another, especially in a pipe chain.
}
\examples{
x <- as.list(1:3)

x \%>\% append("a")
x \%>\% prepend("a")
x \%>\% prepend(list("a", "b"), before = 3)
}
