% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_by.R
\name{split_by}
\alias{order_by}
\alias{sort_by}
\alias{split_by}
\title{Split, order and sort lists by their components.}
\usage{
split_by(.x, .f, ...)

order_by(.x, .f, ...)

sort_by(.x, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula, or atomic vector.

  If a \strong{function}, it is used as is.

  If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a
  function with two arguments, \code{.x} or \code{.} and \code{.y}. This
  allows you to create very compact anonymous functions with up to
  two inputs.

  If \strong{character} or \strong{integer vector}, e.g. \code{"y"}, it
  is converted to an extractor function, \code{function(x) x[["y"]]}. To
  index deeply into a nested list, use multiple values; \code{c("x", "y")}
  is equivalent to \code{z[["x"]][["y"]]}. You can also set \code{.null}
  to set a default to use instead of \code{NULL} for absent components.}

\item{...}{Additional arguments passed on to \code{.f}.}
}
\description{
Split, order and sort lists by their components.
}
\examples{
l1 <- transpose(list(x = sample(10), y = 1:10))
l1
l1 \%>\% order_by("x")
l1 \%>\% sort_by("x")

l2 <- rerun(5, g = sample(2, 1), y = rdunif(5, 10))
l2 \%>\% split_by("g") \%>\% str()
l2 \%>\% split_by("g") \%>\% map(. \%>\% map("y"))
}

