% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{ped_sort}
\alias{ped_sort}
\title{Sort individuals (with ancestors on top of descendants)}
\usage{
ped_sort(ped, id = "id", dam = "dam", sire = "sire", keep_names = FALSE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{id}{A string naming the column with individual identities. It will be renamed to its default value 'id'.}

\item{dam}{A string naming the column with maternal identities. It will be renamed to its default value 'dam'.}

\item{sire}{A string naming the column with paternal identities. It will be renamed to its default value 'sire'.}

\item{keep_names}{A boolean value indicating whether the original identity values should be kept on a separate column (named 'names'), or not.}
}
\value{
A sorted pedigree dataframe (with ancestors on top of descendants).
}
\description{
Individuals can be sorted according to the pedigree structure, without need of birth dates.
In the sorted pedigree, descendants will always be placed in rows with higher index number
than that of their ancestors. This way, individuals born first will tend to be in the top
of the pedigree. Younger individuals, and individuals with no descendants will tend to be
placed at the bottom.
This function uses the sorting algorithm developed by Zhang et al (2009).
After sorting, individuals will be renamed from 1 to N using \code{\link{ped_rename}}.
}
\examples{
data(darwin)
# Here we reshuffle rows in the pedigree. It won't be usable for other functions in the package
darwin <- darwin[sample(1:nrow(darwin)), ]
# Below, we sort the pedigree again. The order might not be the same as before.
# But ancestors will always be placed on top of descendants,
# making the pedigree usable for other functions in the package.
darwin <- ped_sort(darwin, id = "Individual", dam = "Mother", sire = "Father", keep_names = TRUE)
}
\references{
\itemize{
  \item{Zhang Z, Li C, Todhunter RJ, Lust G, Goonewardene L, Wang Z. 2009. An algorithm to sort complex pedigrees chronologically without birthdates. J Anim Vet Adv. 8 (1): 177-182.}
}
}
\seealso{
\code{\link{ped_rename}}
}
