% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ancestors}
\alias{ancestors}
\title{Individuals to be evaluated in purging analyses}
\usage{
ancestors(ped, reference, nboot = 10000L, seed = NULL, skip_Ng = FALSE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{reference}{A string naming a column indicating whether individuals belong to the reference population or not. Column must be boolean or coercible to boolean type.}

\item{nboot}{Number of bootstrap iterations (for computing Ng).}

\item{seed}{Sets a seed for the random number generator.}

\item{skip_Ng}{Skip Ng computation or not (FALSE by default).}
}
\value{
Boolean vector indicating what individuals will be evaluated.
}
\description{
Returns a boolean vector indicating what individuals are suitable for purging analyses, given a measure of fitness.
Individuals with NA values of fitness, and that do not have descendants with non-NA fitness values, are excluded.
}
