% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulseModel.R
\name{pulseModel}
\alias{pulseModel}
\title{pulse function}
\usage{
pulseModel(xita, x)
}
\arguments{
\item{xita}{Six parameters of the pulse function :h0, h1, h2, t1, t2, beta. Details \code{\link{getParams}}}

\item{x}{a vector or point of time}
}
\value{
a vector or point of pulse function value
}
\description{
Pulse function is a pulse function J Comput Biol (2009 Feb) <doi:10.1089/cmb.2008.13TT>.
This is a multiplication of two sigmoid functions, the parameter vector Theta = (h0, h1, h2, t1 t2, beta),
where h0, h1, h2, represent the initial state rate value, peak value and the steady state rate value is reached again,
t1 and t2 are the maximum times of the first and second rise or fall changes, respectively,
and beta is the slope of the two changes.
}
\examples{
load(file.path(system.file(package="pulseTD"),"data","pulseRates.RData"))
TimeGrid <- c(0, 15, 30, 45, 60, 75, 90, 105, 120, 135, 150, 165, 180)
pulseRates_correct <- correctionParams(pulseRates)
transcription_params = getParams(pulseRates_correct,'transcription')
degradation_params = getParams(pulseRates_correct, 'degradation')
processing_params = getParams(pulseRates_correct, 'processing')
###
transcription_pulse = pulseModel(as.matrix(transcription_params[1,]), TimeGrid)
degradation_pulse = pulseModel(as.matrix(degradation_params[1,]), TimeGrid)
processing_pulse = pulseModel(as.matrix(processing_params[1,]), TimeGrid)
}
