% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchtools_config_template.R
\name{findConfFile}
\alias{findConfFile}
\title{find config file}
\usage{
findConfFile(name = "")
}
\arguments{
\item{name}{name of default config or path to config file.}
}
\description{
Find a default config file. First calls \code{batchtools::findConfFile} and then find a pulsar default.
}
\details{
See the batchtools functions \code{batchtools::findConfFile} and \code{batchtools::makeRegistry}. When calling \code{batch.pulsar}, we attempt to use batchtool's default lookup for a config file before calling \code{pulsar::findConfFile}.

For clusters with a queuing submission system, a template file, for
defining worker node resources and executing the batch R code, will need to
be defined somewhere on the system. See \code{\link{findTemplateFile}}.
}
\examples{
## Default config file provided by pulsar runs code in interactive mode
## This is for testing purposes and executes serially.
findConfFile()
## Use the parallel package
## slower than providing the 'ncores' argument to pulsar function, due to
## the overhead of creating the batchtools registry.
findConfFile('parallel')

## Use the snow package to register/execute batch jobs on socket clusters.
findConfFile('snow')
## Use a TORQUE / PBS queing system. Requires brew template file.
findConfFile('torque')
findTemplateFile('simpletorque')

}
\seealso{
\code{\link{findTemplateFile}}
}
