% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.p.value}
\alias{style.apa.p.value}
\title{Formats a p value}
\usage{
style.apa.p.value(x)
}
\arguments{
\item{x}{a list. First item must be a numeric, that will be formatted as p
value. All other list items will be ignored.}
}
\value{
character vector with formatted p values.
}
\description{
This style functions takes a numeric vector in a list and transforms the
items into a character vector with formatted p values.  \code{replace0} is
set to \code{TRUE} and \code{nsmall = 3}. Leading zeros will not be
printed.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
pprint(c(.74895, .00001), format = "p.value")
}
\seealso{
Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

